# norm.rb : normalizing data to 1
# Copyright (C) 2006 Vincent Fourmond

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

module SciYAG

  module Backends

    # A filter that sorts data according to their X values.
    class NormalizeFilter < Filter
      include Dobjects

      describe "norm", "Normalize", 
      "Normalize so that maximum absolute value is 1 " +
        "(keeping the original sign)"

      def initialize
      end

      def apply!(f)
        y_abs_max = Dvector[f.y.min.abs, f.y.max.abs].max
        f.y.div!(y_abs_max)
      end
    end
  end
end
