
/*
 * Copyright (c) 2000 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: backq.m,v 1.18 2002/06/15 19:19:30 stes Exp $
 */

#include <Object.h>
#include <ocstring.h>
#include <ordcltn.h>
#include <assert.h>
#include <curses.h>
#include <unistd.h>
#include "backq.h"
#include "process.h"
#include "pipeline.h"
#include "cursel.h"

@implementation Backquote

- expr:v
{
  expr = v;
  return self;
}

- (STR)str
{
  int c;
  id dstbuf,errbuf;

  if (running) { doworking(1);refreshbanner(); }

  [expr setsrcfd:0];
  [expr setdstbuf:dstbuf = [String new]];
  [expr seterrbuf:errbuf = [String new]];

  [expr go];
  c = [expr exitcode]; /* wait for child */

  if (running && [errbuf size]>0) {
    errbuf=chomp(errbuf);
    [errbuf concatSTR:";"];
    showtransientmessage([errbuf str]);
  }

  if (running) { doworking(0);refreshbanner(); }

  dstbuf=chomp(dstbuf);
  return [dstbuf str];
}

@end

