
/*
 * Copyright (c) 2000 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: field.m,v 1.15 2002/09/01 15:32:11 stes Exp $
 */

#include <assert.h>
#include <curses.h>
#include <stdlib.h>
#include <form.h>
#include <Object.h>
#include <ordcltn.h>
#include <ocstring.h>
#include "field.h"
#include "choices.h"
#include "cursel.h"
#include "frame.h"
#include "formfram.h"

id mkfield(id name,id nrow,id ncol,id frow,id fcol,id rows,id columns,id rmenu,id menuonly,id invalidmsg)
{
  id field = [Field new];
  [field name:name];
  [field nrow:nrow];
  [field ncol:ncol];
  [field frow:frow];
  [field fcol:fcol];
  [field rows:rows];
  [field columns:columns];
  [field rmenu:rmenu];
  [field menuonly:menuonly];
  [field invalidmsg:invalidmsg];
  return field;
}

@implementation Field 

static FIELDTYPE *CURSTYPE;

bool checkfield(FIELD *f,const void *arg)
{
  return [(id)field_userptr(f) validate];
}

+ initialize
{
  CURSTYPE = new_fieldtype(checkfield,NULL);
  return self;
}

- autoadvance:x
{ autoadvance=x;return self; }

- choicemsg:x
{ choicemsg=x;return self; }

- fieldmsg:x
{ fieldmsg=x;return self; }

- frow:x
{ frow=x;return self; }

- fcol:x
{ fcol=x;return self; }

- inactive:x
{ inactive=x;return self; }

- invalidmsg:x
{ invalidmsg=x;return self; }

- lininfo:x
{ lininfo=x;return self; }

- menuonly:x
{ menuonly=x;return self; }

- name:x
{ name = x;return self; }

- noecho:x
{ noecho=x;return self; }

- nrow:x
{ nrow=x;return self; }

- ncol:x
{ ncol=x;return self; }

- page:x
{ page=x;return self; }

- rmenu:x
{ rmenu=x;return self; }

- rows:x
{ rows=x;return self; }

- columns:x
{ columns=x;return self; }

- scroll:x
{ scroll=x;return self; }

- show:x
{ show=x;return self; }

- valid:x
{ valid=x;return self; }

- value:x
{ value=x;return self; }

- wrap:x
{ wrap=x;return self; }

- setform:x
{ form=x;return self; }

- destroy
{
  if (eti_label) free_field(eti_label);
  if (eti_field) free_field(eti_field);
  eti_label = NULL;
  eti_field = NULL;
  return self;
}

- choices
{
  return choices;
}

- (BOOL)needschoicewindow
{
  if (expandbool(menuonly,NO)) {
    return [choices size] > 3;
  } else {
    return YES;
  }
}

static void addChoices(id choices,id s)
{
   char *t;
   char *delim = " \t\n";
   t = strtok([s str],delim);
   if (t) {
      [choices add:[String str:t]];
   }
   while((t=strtok(NULL,delim))) {
     if (t) {
       [choices add:[String str:t]];
     }
   }
}

- (char**)keywlist
{
  int i,n;

  choices = [OrdCltn new];
  for(i=0,n=[rmenu size];i<n;i++) {
   id s = [String str:[[rmenu at:i] str]];
   addChoices(choices,s);
  }

  /* expanded list */
  n = [choices size];

  keywlist = (char**)malloc(sizeof(char*) * (n+2));
  for(i=0;i<n;i++) {
    keywlist[i] = [[choices at:i] str];
  }
  keywlist[n] = NULL;

  return keywlist;
}

- create
{
  char *t;
  BOOL inact;
  id n,v,s;
  int x1,y1,x2,y2,w,h,len;

  n = expandstr(name);
  v = expandstr(value);
  y1 = expandint(nrow,0);
  x1 = expandint(ncol,0); 
  y2 = expandint(frow,0); 
  x2 = expandint(fcol,0);
  h = expandint(rows,1);
  w = expandint(columns,0);

  if (eti_field) [self destroy];

  t = [n str];
  if ((len=strlen(t))) {
   eti_label = new_field(1,len,y1,x1,0,0);
   assert(eti_label);
   set_field_buffer(eti_label,0,t);
   set_field_opts(eti_label,field_opts(eti_label) & ~O_ACTIVE);
  }

  t=[v str];
  eti_field = new_field(h,w,y2,x2,0,0);
  assert(eti_field);
  if (v) set_field_buffer(eti_field,0,t);

  inact = expandbool(inactive,NO);

  if (has_colors()) {
    set_field_fore(eti_field,A_NORMAL|COLOR_PAIR(colorpairs[CP_TEXT]));
    if (inact) {
     set_field_back(eti_field,A_NORMAL|COLOR_PAIR(colorpairs[CP_TEXT]));
    } else {
     set_field_back(eti_field,A_UNDERLINE|COLOR_PAIR(colorpairs[CP_TEXT]));
    }
    if (eti_label) {
      set_field_fore(eti_label,A_NORMAL|COLOR_PAIR(colorpairs[CP_TEXT]));
      set_field_back(eti_label,A_NORMAL|COLOR_PAIR(colorpairs[CP_TEXT]));
    }
  } else {
    set_field_fore(eti_field,A_NORMAL);
    if (inact) {
     set_field_back(eti_field,A_NORMAL);
    } else {
     set_field_back(eti_field,A_UNDERLINE);
    }
    if (eti_label) {
      set_field_fore(eti_label,A_NORMAL);
      set_field_back(eti_label,A_NORMAL);
    }
  }

  /* for field validation */
  set_field_type(eti_field,CURSTYPE);

  if ([rmenu isKindOf:(id)[Choices class]]) {
    if (expandbool(menuonly,YES)) {
      set_field_type(eti_field,TYPE_ENUM,[self keywlist],FALSE,FALSE);
    }
  }

  if (inact) {
    set_field_opts(eti_field,field_opts(eti_field) & (~O_ACTIVE));
  }

  set_field_userptr(eti_field,self);
  return self;
}

- (FIELD*)eti_label
{
  return eti_label;
}

- (FIELD*)eti_field
{
  return eti_field;
}

- invalidfieldmsg
{
  char *s;
  s = (invalidmsg)?[expandstr(invalidmsg) str]:"Input is not valid";
  showtransientmessage(s);
  return self;
}

- (BOOL)validate
{
  [form deffieldvars];
  validated = expandbool(valid,YES);
  [form undeffieldvars];
  if (!validated) [self invalidfieldmsg];
  return validated;
}

@end
 
