
/*
 * Copyright (c) 2000 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: subproc.m,v 1.1 2002/06/15 19:19:31 stes Exp $
 */

#include <assert.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <curses.h>
#include <Object.h>
#include "cursel.h"
#include "process.h"
#include "subproc.h"
#include "frame.h"

@implementation Subprocess

- expr:v
{
  expr = v; return self;
}

- go
{
  int fd[2];
  int dfd[2];
  int efd[2];
  int i,n,ok;
  
  fd[1]=-1;efd[1]=-1;dfd[1]=-1;

  /* first statement in a pipeline */
  if (makepipe) {
    assert(dstbuf == nil);
    ok = pipe(fd);
    assert(ok == 0);
    pipefd = fd[0];
    dstfd = fd[1];
  }

  /* set srcfd,dstfd,errfd if redirected */
  [self openredirs];

  if (background) [self setsigchldhandler];

  if (dstbuf) { ok=pipe(dfd);assert(ok == 0);dstfd = dfd[1]; }
  if (errbuf) { ok=pipe(efd);assert(ok == 0);errfd = efd[1]; }

  ok = fork();
  assert(ok != -1);

  pid = (background)?0:ok;

  if (ok) {
    if (fd[1]>=0) {
      ok = close(dstfd);assert(ok == 0);
    }
    if (dfd[1]>=0) {
      ok = close(dstfd);assert(ok == 0);
      dstbuf = strfromfd(dstbuf,dfd[0]);
      ok = close(dfd[0]);assert(ok == 0);
    }
    if (efd[1]>=0) {
      ok = close(errfd);assert(ok == 0);
      errbuf = strfromfd(errbuf,efd[0]);
      ok = close(efd[0]);assert(ok == 0);
    }
  } else {
    [expr setsrcfd:srcfd];
    [expr setdstfd:dstfd];
    [expr seterrfd:errfd];
    [Frame unblockalarm];
    signal(SIGINT,(u_interrupt)?SIG_DFL:SIG_IGN);
    [expr go];
    _exit(0);
  }

  exitcode = [self exitcode];
  [self closeredirs];
  return self;
}

@end

