/***************************************************************************
                          configdatei.cpp  -  description
                             -------------------
    begin                : Sun Jul 1 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cuyointl.h"

#include "configdatei.h"


#define zeilentyp_leer 0
#define zeilentyp_abschnitt 1
#define zeilentyp_zuweisung 2



ConfigDatei::ConfigDatei(__String name):
  mName(name), mDatei(name), mStream(&mDatei),
  mEinSpielerVersion(false)
{
  if (mDatei.exists())
    mOffen = mDatei.open(IO_ReadOnly);
  else
    mOffen = false;
  setAbschnitt();
}

ConfigDatei::~ConfigDatei() {
  /* Wird alles automatisch erledigt */
}


/** Liefert den aktuellen Abschnitt */
__String ConfigDatei::getAbschnitt() const {
  return mAbschnitt;
}


/** Wechselt zum angegebenen Abschnitt. (Abschnitte werden durch
[bla] eingeleitet.) Liefert false, wenn der Abschnitt nicht existiert. */
bool ConfigDatei::setAbschnitt(__String na /*= ""*/) {
  if (na.isEmpty()) {
    /* Anfangs-Abschnitt */
    mAbschnitt = na;
    mAbschnittPos = 0;
    return true;
		
  } else {
    /* Datei berhaupt offen? */
    if (!mOffen)
      return false;
	
    /* Abschnitt suchen */
    mDatei.at(0);
    __String z;
    while (!mDatei.atEnd()) {
      z = mStream.readLine();
      int a, b;
      if (getZeilenTyp(z, a, b) == zeilentyp_abschnitt) {
	if (na == z.mid(a, b - a)) {
	  /* Abschnit gefunden */
	  mAbschnitt = na;
	  mAbschnittPos = mDatei.at();
	  return true;
	}
					
      }
    } // while Datei nicht zu Ende
		
    /* Abschnitt nicht gefunden */
    return false;
  }
}


/** Liefert zurck, was fr ein Zeilentyp die Zeile ist:
    leer, abschnitt, zuweisung. In a und b werden interessante
    Positionen abgespeichert:
    Bei abschnitt: a = Pos. nach "["; b = Pos von "]"
    Bei zuweisung: a = Anfangspos; b = Pos nach "=" */
int ConfigDatei::getZeilenTyp(const __String & z, int & a, int & b) const {
  int p = 0;
  if (z.isEmpty())
    return zeilentyp_leer;
  /* Leertasten am Anfang weg */
  while (z[p] == ' ' || z[p] == '\t')
    p++;
	
  switch (z[p]) {
  case '#':
  case 0:
    /* Leer-Zeile */
    return zeilentyp_leer;
		
  case '[':
    /* Abschnitt-Zeile */
    a = p + 1;
    while (z[p] != ']') {
      if (z[p] == 0) {
	fehlerZeile(z);
	return zeilentyp_leer;
      }
      p++;
    }
    b = p;
		
    /* Hier knnte man jetzt noch testen, ob danach auch wirklich nichts mehr
       kommt... */
		
    return zeilentyp_abschnitt;
		
  default:
    /* Zuweisungs-Zeile */
    a = p;
    while (z[p] != '=') {
      if (z[p] == 0) {
	fehlerZeile(z);
	return zeilentyp_leer;
      }
      p++;
    }
    b = p + 1;
		
    return zeilentyp_zuweisung;
  }
	
}


/** Wenn ein Parse-Fehler in Zeile z aufgetreten ist... */
void ConfigDatei::fehlerZeile(const __String & z) const {
  fprintf(stderr, _("Parse error in file %s: %s\n"),
	  mName.data(), z.data());
}



/** Liefert den Eintrag, wenn er existiert, sonst den default-String
    (der per default null ist). Schaut ggf. nach EinSpieler-Eintrag. */
__String ConfigDatei::getEintrag(__String schluessel, __String def) const {
	
  __String ret;
	
  /* Evtl. EinSpieler-Eintrag suchen */
  if (mEinSpielerVersion)
    ret = getEintragIntern(schluessel + '1');
	
  /* Normalen Eintrag suchen */
  if (ret.isNull())
    ret = getEintragIntern(schluessel, def);
	
  return ret;
}

	
/** Liefert den Eintrag, wenn er existiert, sonst den default-String
    (der per default null ist). Schaut _nicht_ nach EinSpieler-Eintrag */
__String ConfigDatei::getEintragIntern(__String schluessel, __String def) const {

  /* Datei berhaupt offen? */
  if (!mOffen)
    return def;

  mDatei.at(mAbschnittPos);
	
  while (!mDatei.atEnd()) {
    __String z = (__String) mStream.readLine();
    int a, b, t;
    t = getZeilenTyp(z, a, b);
    if (t == zeilentyp_abschnitt) break;
		
    if (t == zeilentyp_zuweisung) {
      /* OK, hier ist eine Zuweisung. Ist es die richtige? */
      if (schluessel == z.mid(a, b - 1 - a)) {
				/* Ja */
	return z.mid(b, 0x7fff);
      }
    }
  }
	
  return def;
}


/** Gibt's den Eintrag? */
bool ConfigDatei::hatEintrag(__String schluessel) const {
  return !getEintrag(schluessel).isNull();
}


/** Liefert den Eintrag als Zahl, wenn er existiert, sonst die default-Zahl. */
int ConfigDatei::getZahlEintrag(__String schluessel, int def /*= 0*/) const {
  __String e = getEintrag(schluessel);
  if (e.isNull())
    return def;
  else {
    int ret = def;
    sscanf(e.data(), "%d", &ret);
    return ret;
  }
}

/** Liefert den Eintrag als Farbe, wenn er existiert,
    sonst die default-Farbe. */
QColor ConfigDatei::getFarbEintrag(__String schluessel,
				   const QColor & def /*= __black*/) const {
  __String e = getEintrag(schluessel);
  if (e.isNull())
    return def;
  else {
    int r, g, b;
    sscanf(e.data(), "%d,%d,%d", &r, &g, &b);
    return QColor(r, g, b);
  }
}

/** Liefert einen Eintrag als Komma-getrennte Liste */
int ConfigDatei::getListenEintrag(__String schluessel, QStrList & liste) const {
  __String e = getEintrag(schluessel);

  /* Gibt's den Eintrag berhaupt? */
  if (e.isNull())
    return 0;

  /* Liste lschen */
  while (!liste.isEmpty())
    liste.removeFirst();
	
  /* Leere Liste? */
  if (e.isEmpty())
    return 0;
		
  /* Evtl. Schlusskomma anhngen */
  if (e.at(e.length() - 1) != ',')
    e += ',';
	
  /* String zerlegen */
  int anz = 0;
  int p = 0, vp = 0;
  while (e[p]) {
    if (e[p] == ',') {
      liste.append(e.mid(vp, p - vp));
      vp = p + 1;
      anz++;
    }
    p++;
  }
  return anz;
}

/** Setzt, ob nach Ein-Spieler-Version-Schlsseln
gesucht werden soll */
void ConfigDatei::setEinSpielerVersion(bool esv /*= false*/) {
  mEinSpielerVersion = esv;
}
