/***************************************************************************
                          knoten.cpp  -  description
                             -------------------
    begin                : Mit Jul 12 22:54:51 MEST 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdlib>
#include <cstdio>

#include "cuyointl.h"
#include "knoten.h"
#include "code.h"
#include "blop.h"
#include "leveldaten.h"
#include "global.h"


/*************************************************************************/
/* Was von vornerein so im Namespace rumliegt */


/* xxx_anz wird in blop.h definiert. */

char spezvar_namen[spezvar_anz][22] = {
  "file", "pos", "kind", "version", "qu",
  "out1", "out2",
  "", // kind_beim_letzten_draw_aufruf; ist nicht fr den User gedacht.
  "inhibit", "goalblob"
};

int spezvar_default[spezvar_anz] = {
  0, 0, blopart_ausserhalb, 0, viertel_alle,
  spezvar_out_nichts, spezvar_out_nichts,
  -1,
  0, 0
};


/* Reihenfolge -1, -2, -3, ... */
char spezconst_namen[spezconst_anz][22] = {
  "turn", "connect", "falling", "size", "loc_x", "loc_y", "loc_p",
  "players", "falling_fast", "exploding", "loc_xx", "loc_yy"
};

int spezconst_default[spezconst_anz] = {
  0, 0, 0, 0, -1, -1, 0,
  0
};


#define const_anz (21+2+2*9)
//int const_anz = feste_konst_anz;
char const_namen[const_anz][22] = {
  /* Viertelstckchen */
  "Q_ALL",
  "Q_TL", "Q_TR", "Q_BL", "Q_BR",
  "Q_TL_TL", "Q_TR_TL", "Q_BL_TL", "Q_BR_TL",
  "Q_TL_TR", "Q_TR_TR", "Q_BL_TR", "Q_BR_TR",
  "Q_TL_BL", "Q_TR_BL", "Q_BL_BL", "Q_BR_BL",
  "Q_TL_BR", "Q_TR_BR", "Q_BL_BR", "Q_BR_BR",
  
  /* Verwandlungsziele */
  "nothing", "outside",
  /* Buchstaben, die in den Strings in Nachbariterator verwendet werden. */
  /*   A        B         C        D         E          F          G          H          I */
  "DIR_U", "DIR_UR", "DIR_R", "DIR_DR", "DIR_UUL", "DIR_UUR", "DIR_RRU", "DIR_RRD", "DIR_F",
  "DIR_D", "DIR_DL", "DIR_L", "DIR_UL", "DIR_DDR", "DIR_DDL", "DIR_LLD", "DIR_LLU", "DIR_B"
};

/* Eigentlich sollten hier die Konstanten aus bilddatei.h verwendet werden;
   das wre aber so viel Tipparbeit... */
int const_werte[const_anz] = {
  /* Viertelstckchen */
  viertel_alle,
  0, 5, 10, 15,
  0, 1, 2, 3,
  4, 5, 6, 7,
  8, 9, 10, 11,
  12, 13, 14, 15,
  
  /* Verwandlungsziele */
  blopart_keins, blopart_ausserhalb,
  
  /* Richtungskonstanten fr inhibit */
  0x00000001, 0x00000002, 0x00000004, 0x00000008, 0x00000010, 0x00000020, 0x00000040, 0x00000080, 0x00000100,
  0x00010000, 0x00020000, 0x00040000, 0x00080000, 0x00100000, 0x00200000, 0x00400000, 0x00800000, 0x01000000
};



/*************************************************************************/
/* Knoten */


/** Liefert einen String zurck, der angibt, wo dieser Code
    definiert wurde (fr Fehlermeldungen) */
__String Knoten::getDefString() const {
  __String ret;
  ret.sprintf("%s:%d", mDateiName.data(), mZeilenNr);
  return ret;
}




/*************************************************************************/
/* DefKnoten */


#if map_stl
/* Bei QT1 gibt's kein qmap.h; also stl-map verwenden.
   Defines, um spter auf die selbe Art auf die verschiedenen
   Maps zugreifen zu knnen. */

typedef tKnotenMap::iterator tKnotenMapIterator;
typedef tKnotenMap::const_iterator tKnotenMapConstIterator;
#define iterLinks(it)          ((*it).first)
#define iterRechts(it)         ((*it).second)
#define mapEnthaelt(map, obj)  ((map).find(obj) != (map).end())

#else 

typedef tKnotenMap::Iterator tKnotenMapIterator;
typedef tKnotenMap::ConstIterator tKnotenMapConstIterator;
#define iterLinks(it)          ((it).key())
#define iterRechts(it)         ((it).data())
#define mapEnthaelt(map, obj)  ((map).contains(obj))

#endif



/** Erzeugt den Top-Knoten. */
DefKnoten::DefKnoten():
  Knoten("?", 0),
  mVater(0), mTiefe(tiefe_global),
  mErstLevelDannCual(0),
  mVarNrBei(0),
  mBoolNrBei(-1),
  mDefaultWerte(QArray<int>())
{
  /* Die vordefinierten Namespace-Dinge einfgen. */
  speicherGlobaleVordefinierte();
}


/** Erzeugt einen Unter-Knoten. */
DefKnoten::DefKnoten(__String datna, int znr, DefKnoten * vater):
  Knoten(datna, znr),
  mVater(vater), mTiefe(vater->mTiefe + 1),
  mErstLevelDannCual(0),
  /* Das ganze Variablen-Zeug vom Vater bernehmen...: */
  mVarNrBei(vater->mVarNrBei),
  mBoolNrBei(vater->mBoolNrBei),
  mDefaultWerte(vater->mDefaultWerte.copy())
{
}

DefKnoten::~DefKnoten() {
  tKnotenMapIterator it;
  for(it = mKinder.begin(); it != mKinder.end(); ++it)
    delete iterRechts(it);
}




__String DefKnoten::toString() const {
  tKnotenMapConstIterator it;
  __String ret = "{\n";
  for(it = mKinder.begin(); it != mKinder.end(); ++it) {
    ret += iterLinks(it) + "=" + iterRechts(it)->toString() + "\n";
  }
  ret += "}\n";
  return ret;
}


void DefKnoten::fuegeEin(const __String & na, Knoten * wert) {
  if (mapEnthaelt(mKinder, na))
    throw Fehler(_("\"%s\" already defined."), na.data());
  mKinder[na] = wert;

  /* Wenn ein neuer Level geparst wird, will das ld evtl. wissen.
     (Falls der Benutzer neu gemachte Level ausprobieren will,
     die noch nicht in "level=..." stehen.) */
  if (mTiefe == tiefe_global && wert->type() == type_DefKnoten) {
    ld->levelGefunden(na);
    
    /* Und bei der Gelegenheit merken wir uns gleich noch, dass schon
       ein Level in diesem Knoten ist. Wenn jetzt noch Cual-Code kommt,
       ist das gefhrlich, und es soll eine Warnung ausgegeben werden. */
    mErstLevelDannCual |= 1;
  }
  
  /* Auf Level-Ebene evtl. noch ein paar Konstanten einfgen... */
  if (mTiefe == tiefe_level) {
    /* pics-Eintrag? Dann knnen ja jetzt die pics-Konstanten erzeugt
       werden. */

    /* Wenn beim Definieren der Konstanten ein mehrfach-definiert-Fehler
       auftritt, dann soll der nicht ausgegeben werden; die neue
       Definition wird einfach ignoriert. Das ist ntig bei irgend welchen
       Test-Leveln, wo fr mehrere Sorten einfach das gleiche verwendet
       wird. */
    try {
    
      /* Achtung, verwirrend: wert ist nicht der Wert der Konstante,
         sondern das, was rechts vom "=" in der ld-Datei steht. */
      if (na == "pics")
	speicherPicsConst(wert);
      if (na == "greypic")
	speicherKnotenConst(wert, blopart_grau);
      if (na == "startpic")
	speicherKnotenConst(wert, blopart_gras);
      if (na == "emptypic")
	speicherKnotenConst(wert, blopart_keins);
    
    } catch (Fehler fe) {
    }
    
  }
}


/** Lscht alle Kinder raus, die DefKnoten sind und nicht
    "Title" heien.
    Wird von LevelDaten::ladLevelConf() gebraucht. */
void DefKnoten::loeschAlleLevel() {
  tKnotenMapIterator it = mKinder.begin(), nae;
  while (it != mKinder.end()) {
    Knoten * k = iterRechts(it);
    nae = it; ++nae;
    
    if (k->type() == type_DefKnoten && iterLinks(it) != "Title") {
#if map_stl
      mKinder.erase(it);
#else
      mKinder.remove(it);
#endif
      delete k;
    }
    it = nae;
  }
}


/***** Methoden fr den Codespeicher *****/



/** Speichert alle vordefinierten Variablen in den
    Namespace, auer die pics-Konstanten. Wird vom Constructor
    des WurzelKnotens aufgerufen. */
void DefKnoten::speicherGlobaleVordefinierte() {

  /* Spezial-Variablen (z. B. file); Nummern ab 0 */
  /* Das sollten die ersten Variablen sein, die erzeugt werden;
     sonst stimmen nachher die Nummern nicht. */
  CASSERT(mVarNrBei == 0);
  for (int i = 0; i < spezvar_anz; i++) {
    /* Nicht direkt mit speicherDefinition() erzeugen; sonst
       werden die Default-Werte nicht nochmal in mDefaultWerte
       gespeichert. */
    neueVarDefinition(spezvar_namen[i], spezvar_default[i]);
  }
  
  /* Spezial-Konstanten (d. h. Variablen, die nur gelesen werden
     werden knnen), z. B. verbindung; Nummern < 0 */
  for (int i = 0; i < spezconst_anz; i++)
    speicherDefinition(namespace_variable, spezconst_namen[i],
        new VarDefinition(spezconst_namen[i], spezconst_default[i],
                          vd_spezconst, -i-1)
      );
  
  /* Ganz normale feste Konstanten (z. B. nochange); haben keine Nummern,
     weil schon zu parse-Zeit der Wert eingesetzt wird.
     (Das passiert in parser.yy, da wo aus der Variable ein Code wird.) */
  for (int i = 0; i < const_anz; i++)
    speicherDefinition(namespace_variable, const_namen[i],
        new VarDefinition(const_namen[i], const_werte[i],
                          vd_konstante)
      );

}



/** Speichert die Pics-Konstanten. (picsliste sollte der pics-Knoten sein.)
    Wird von fuegeEin(...) aufgerufen, wenn es die pics bekommt. */
void DefKnoten::speicherPicsConst(Knoten * picsliste) {
  /* pics-Konstanten. (Eigentlich knnten wir gleich eine Fehlermeldung
     ausspucken, wenn der Typ von picsliste falsch ist, aber die anderen
     entsprechenden Typ-Fehlermeldungen kommen auch erst beim Starten des
     Levels. Also hier erst mal ruhig sein. */
  if (picsliste->type() == type_ListenKnoten) {
    ListenKnoten * lki = (ListenKnoten*) picsliste;
    for (int i = 0; i < lki->getLaenge(); i++) {
      /* picsEndungWeg() steht in global.* */
      __String varna = picsEndungWeg(lki->getKernDatum(i,type_WortDatum)
				     ->getWort());
      speicherDefinition(namespace_variable, varna,
          new VarDefinition(varna, lki->getLaengeBis(i), vd_konstante)
        );
     }
  }
}


/** Speichert eine Konstante mit dem Namen, der in nameKnoten steht und
    dem angegebenen Wert. nameKnoten ist hoffentlich ein ListenKnoten
    mit genau einem Eintrag. Wird von fuegeEin() aufgerufen, um die
    Gras-, die Grau- und die nix-Konstante abzuspeichern, wenn es die
    bekommt. */
void DefKnoten::speicherKnotenConst(Knoten * nameKnoten, int wert) {
  /* Keine Fehlermeldung bei falschem Typ; siehe speicherPicsConst() */
  if (nameKnoten->type() == type_ListenKnoten) {
    ListenKnoten * lk = (ListenKnoten*) nameKnoten;
    if (lk->getLaenge() == 1) {
      __String varna = picsEndungWeg(lk->getDatum(0,type_WortDatum)
				     ->getWort());
      speicherDefinition(namespace_variable, varna,
          new VarDefinition(varna, wert, vd_konstante)
        );
    }
  }
}



/* Erzeugt eine neue Var-Definition und speichert sie ab. Dabei
   bekommt sie auch gleich eine Nummer. (Aufzurufen, wenn eine
   VarDefinition geparst wurde.) def ist der Default-Wert. */
void DefKnoten::neueVarDefinition(const __String & na, int def) {
  //fprintf(stderr, "Define %s\n", na.data());
  if (na == "") {
    /* Wenn kein Name angegeben wurde, handelt es sich wohl um eine
       Spez-Var, die fr den User unsichtbar sein soll. Dann nur
       die Variable erzeugen, aber keine Definition abspeichern. */
    neueVariable(def);
  } else {
    speicherDefinition(namespace_variable, na,
      new VarDefinition(na, def, vd_variable, neueVariable(def)));
  }
}


/* Speichert eine neue Definition - Code oder Variable. Noch unschn:
   Sollte von auen nur fr Code aufgerufen werden. Bei Variablen immer
   neueVarDefinition verwenden! */
void DefKnoten::speicherDefinition(int ns, const __String & na,
                                   Definition * f) {
/*  printf("Speichere %s = %s\n", na.data(),
         f->toString().data());*/
  if (mapEnthaelt(mCodeSpeicher[ns], na))
    throw Fehler(_("\"%s\" already defined."), na.data());

  /* (Vielleicht kennt Papi den Code schon, aber das kann man
     berschreiben.) */
     
  mCodeSpeicher[ns][na] = f;
  
  /* Wenn wir der globale Knoten sind und schon eine Level-Defintion kam,
     dann Warnung ausgeben. */
  if (gDebug && mErstLevelDannCual == 1) {
    fprintf(stderr, _("Warning: There's global Cual code _after_ the some level definitions. Be sure\n"
              "not to use that Cual code in the levels before it. (Due to a bug, this will\n"
	      "sometimes not result in an error message but in strange behaviour.)\n"));
    mErstLevelDannCual |= 2;
  }
}



/** Liefert eine Code-Definition aus diesem Speicher oder von
    weiter oben. Throwt bei Nichtexistenz.
    Achtung: Behlt den Besitz an der Defintion. */
Definition * DefKnoten::getDefinition(int ns, __String na) {

  Definition * ret;


  if (!mapEnthaelt(mCodeSpeicher[ns], na)) {
    /* Wir kennen den Code nicht. Also Papi fragen. */
    if (mVater)
      return mVater->getDefinition(ns, na);
      
    /* Ups, wir haben ja gar keinen Papi. */
    throw Fehler(_("\"%s\" not defined inside << >>."), na.data());
  }
  
  ret = mCodeSpeicher[ns][na];
  
  return ret;
}




/***** Variablen-Nummern-Verwaltung *****/


/** Erzeugt eine unbenannte Variable
    und liefert die Nummer zurck. */
int DefKnoten::neueVariable(int def) {
  /* Sorten-Variablen gibt's nicht (wirklich). Die kommen in den
     Level-Knoten */
  if (mTiefe == tiefe_sorte)
    return mVater->neueVariable(def);

  CASSERT((int) mDefaultWerte.size() == mVarNrBei);
  //fprintf(stderr, "t=%d  %d %d\n", mTiefe, mDefaultWerte.size(), mVarNrBei);
  /* Das kann man auch schneller machen... (immer mehr auf einmal
     reservieren) falls das QT nicht eh tut */
  mDefaultWerte.resize(mVarNrBei + 1);
  mDefaultWerte[mVarNrBei] = def;
  
  return mVarNrBei++;
}




/** Erzeugt eine unbenannte Bool-Variable und liefert
    die Nummer zurck. */
int DefKnoten::neueBoolVariable() {
  /* Sorten-Variablen gibt's nicht (wirklich). Die kommen in den
     Level-Knoten */
  if (mTiefe == tiefe_sorte)
    return mVater->neueBoolVariable();

  if (mBoolNrBei == -1) {
    /* Grad kein Platz mehr fr Bools. Also neuen
       Platz erzeugen. */
    mBoolNrBei = bits_pro_int * neueVariable(0);
  }
  
  int ret = mBoolNrBei;
  mBoolNrBei++;
  
  /* Ist das aktuelle int voll mit Bools? */
  if (mBoolNrBei % bits_pro_int == 0) {
    mBoolNrBei = -1;
  }
  
  return ret;
}



int DefKnoten::getDatenLaenge() const {
  CASSERT(mTiefe == tiefe_level);
  return mVarNrBei;
}


  
/** Liefert den Default-Wert der Variable mit Nummer nr. Es
    muss aber eine richtige Variable sein, die echten Blop-
    Speicherplatz verbraucht. (Sonst soll man sich den Default-
    Wert aus der VarDefinition holen. Das hier ist nur fr
    Variablen-Anfangs-Initialisierung.) */
int DefKnoten::getDefaultWert(int nr) const {
  return mDefaultWerte[nr];
}




/*************************************************************************/
/* ListenKnoten */

__String ListenKnoten::toString() const {
  __String ret;
  const Knoten * k;
  bool mitte = false;
  for (k = mKinder.first(); k != 0; k = mKinder.next()) {
    if (mitte) ret += ", ";
    mitte = true;
   
    ret += k->toString();
  }
  return ret;
}



int ListenKnoten::getVielfachheit(int nr) const {
  DatenKnoten * k = (DatenKnoten *) (mKinder.at(nr));
  CASSERT(k->type() == type_DatenKnoten);
  if (k->datatype()==type_VielfachheitDatum)
    return k->getZahl();
  else
    return 1;
}



int ListenKnoten::getImpliziteLaenge() const {
  return getLaengeBis(getLaenge());
}



int ListenKnoten::getLaengeBis(int nr) const {
  int ret=0;
  for (int i=0; i<nr; i++)
    ret += getVielfachheit(i);
  return ret;
}


const DatenKnoten * ListenKnoten::getDatum(int nr,
					   int solltyp /*= type_EgalDatum*/) {
  Knoten * k = mKinder.at(nr);
  CASSERT(k->type() == type_DatenKnoten);
  return ((DatenKnoten *) k)->assert_datatype(solltyp);
}



const DatenKnoten * ListenKnoten::getKernDatum(int nr,
					       int solltyp
					       /*= type_EgalDatum*/) {
  const DatenKnoten * d = getDatum(nr);
  if (d->datatype() == type_VielfachheitDatum)
    d = ((VielfachheitKnoten *) d)->getNurDasWort();
  return d->assert_datatype(solltyp);
}



const DatenKnoten * ListenKnoten::getImplizitesDatum(int nr,
						     int solltyp
						     /*= type_EgalDatum*/) {
  int nr_ = 0;
  int vielfachheit = getVielfachheit(0);
  while (nr>=vielfachheit) {
    nr -= vielfachheit;
    nr_++;
    vielfachheit = getVielfachheit(nr_);
  };
  return getKernDatum(nr_,solltyp);
}




/*************************************************************************/
/* DatenKnoten */

const DatenKnoten * DatenKnoten::assert_datatype(int solltyp) const {
  if ((solltyp != datatype()) && (solltyp!=type_EgalDatum)) {
    __String solltyp_Darstellung = "<unknown type, please report>";
    if (solltyp==type_WortDatum)
      solltyp_Darstellung = "string";
    if (solltyp==type_ZahlDatum)
      solltyp_Darstellung = "int";
    if (solltyp==type_VielfachheitDatum)
      solltyp_Darstellung = "string * int";
    throw Fehler(_("%s is of wrong type. %s expected"),
		 (const char *) toString(),
		 (const char *) solltyp_Darstellung);
  }
  return this;
}




/*************************************************************************/
/* WortKnoten */

__String WortKnoten::getWort(int rolle /*= wortrolle_einziges*/) const {
  CASSERT(rolle==wortrolle_einziges);
  return mWort;
}

__String WortKnoten::toString() const {
  return mWort;
}




/*************************************************************************/
/* ZahlKnoten */

int ZahlKnoten::getZahl(int rolle /*= zahlrolle_einziges*/) const {
  CASSERT(rolle==zahlrolle_einzige);
  return mZahl;
}

__String ZahlKnoten::toString() const {
  __String ret;
  ret.sprintf("%d", mZahl);
  return ret;
}




/*************************************************************************/
/* VielfachheitKnoten */

int VielfachheitKnoten::getZahl(int rolle /*= zahlrolle_einzige*/) const {
  CASSERT(rolle==zahlrolle_einzige);
  return mZahl;
}

__String VielfachheitKnoten::getWort(int rolle
				     /*= wortrolle_einziges*/) const {
  CASSERT(rolle==wortrolle_einziges);
  return mWort;
}

__String VielfachheitKnoten::toString() const {
  __String ret;
  ret.sprintf("%s * %d",(const char *) mWort,mZahl);
  return ret;
}

