/***************************************************************************
                          cuyointl.cpp  -  description
                             -------------------
    begin                : Sun Nov 9 2008
    copyright            : (C) 2008 by Mark Weyer
    email                : cuyo-devel@nongnu.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <config.h>
#include "cuyointl.h"

#ifdef ENABLE_NLS

  #include <locale.h>
  #include <string.h>

  char* our_gettext(const char* to_translate) {
    if (*to_translate)
      return gettext(to_translate);
    else return "";
  }

  /* TRANSLATORS: Replace this string by any other string. Just do not leave
     it as it is. Otherwise we might think that there is no translation into
     your language. */
  const char cuyo_key[] = N_("__cuyo_translation_availability_test");

  void init_NLS() {

    /* PACKAGE comes from config.h.
       LOCALEDIR is given on the command line, but also originates from
       the configure run. */

    setlocale (LC_ALL, "");

    /* For the benefit of us developers: Try the current directory first. */
    bindtextdomain (PACKAGE, "./locale");
    textdomain (PACKAGE);
    /* ... but only if there does seem to be a translation.
       Otherwise take the usual location.
       Whether there is a translation is determined by whether cuyo_key
       has a translation.
     */
    if (!strcmp(_(cuyo_key),cuyo_key)) {
      bindtextdomain (PACKAGE, LOCALEDIR);
      textdomain (PACKAGE);
    }

    bind_textdomain_codeset (PACKAGE, "ISO-8859-1");

  }

#else

  void init_NLS() {}

#endif




