/* $Id: cyrus.h,v 1.6 2003/07/26 16:23:13 mad Exp $ */

/* 
 * Copyright (c) 1994-2000 Carnegie Mellon University. All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright 
 * notice, this list of conditions and the following disclaimer. 
 * 
 * 2. Redistributions in binary form must reproduce the above copyright 
 * notice, this list of conditions and the following disclaimer in 
 * the documentation and/or other materials provided with the 
 * distribution. 
 * 
 * 3. The name "Carnegie Mellon University" must not be used to 
 * endorse or promote products derived from this software without 
 * prior written permission. For permission or any legal 
 * details, please contact 
 * Office of Technology Transfer 
 * Carnegie Mellon University 
 * 5000 Forbes Avenue 
 * Pittsburgh, PA 15213-3890 
 * (412) 268-4387, fax: (412) 268-7395 
 * tech-transfer@andrew.cmu.edu 
 * 
 * 4. Redistributions of any form whatsoever must retain the following 
 * acknowledgment: 
 * "This product includes software developed by Computing Services 
 * at Carnegie Mellon University (http://www.cmu.edu/computing/)." 
 * 
 * CARNEGIE MELLON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO 
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
 * AND FITNESS, IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE 
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN 
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
*/

#ifndef __CYRUS_H
#define	__CYRUS_H

#include <stdio.h>


/* ------------------------------------------------------------------------ */

#if UINT_MAX == BIT32_MAX
typedef unsigned int bit32;
#else
#if ULONG_MAX == BIT32_MAX
typedef unsigned long bit32;
#else
#if USHRT_MAX == BIT32_MAX
typedef unsigned short bit32;
#else
#warning dont know what to use for bit32
#warning trying with unsigned long
typedef unsigned long bit32;
#endif
#endif
#endif

#define PRIME (2147484043UL)

#define MAX_USER_FLAGS (16*8)

#define FLAG_ANSWERED (1<<0)
#define FLAG_FLAGGED (1<<1)
#define FLAG_DELETED (1<<2)
#define FLAG_DRAFT (1<<3)

struct index_header {
    bit32 generation_no;
    bit32 format;
    bit32 minor_version;

    bit32 start_offset;
    bit32 record_size;
    bit32 exists;
    bit32 last_appenddate;
    bit32 last_uid;
    bit32 quota_mailbox_used;
    bit32 pop3_last_login;
    bit32 uidvalidity;

    /* 2.0+, minor_version = 3 */
    bit32 deleted;
    bit32 answered;
    bit32 flagged;

    /* 2.1+, minor_version = 4 */
    bit32 pop3_new_uidl;
    bit32 spare0;
    bit32 spare1;
    bit32 spare2;
    bit32 spare3;
};

struct index_entry {
    bit32 uid;
    bit32 internaldate;
    bit32 sentdate;
    bit32 size;
    bit32 header_size;
    bit32 content_offset;
    bit32 cache_offset;
    bit32 last_updated;
    bit32 system_flags;
    bit32 user_flags[MAX_USER_FLAGS/32];
};


/* ------------------------------------------------------------------------ */

void mailbox_make_uniqueid(char *name, unsigned long uidvalidity,
                char *uniqueid);


/* ------------------------------------------------------------------------ */

#endif
