/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_output_node_hpp_
#define dammit_output_node_hpp_ 1

#include "action_node.hpp"

#include "intrusive_ptr_list.hpp"

#include <dammit/path.hpp>

namespace dammit {

class output_node :
	public node
{
public:
	virtual ~output_node(void) throw() { }

	virtual intrusive_ptr<node> apply(visitor &);
	virtual void apply(const_visitor &) const;

	path directory;
	path filename;

	typedef intrusive_ptr_list<node> input_list;
	typedef input_list::iterator input_iterator;

	input_list inputs;

	intrusive_ptr<action_node> action;

	std::string subdirectory;

	enum type
	{
		executable,
		static_library,
		cxx_header
	};

	type filetype;

	enum audience_type
	{
		users,
		developers,
		translators
	};

	audience_type audience;
};

}

#endif
