/*
 * Danpei -- a GTK+ based Image Viewer
 * Copyright (C) 2001-2003 Shinji Moiino
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* option_menu.h */

#ifndef __OPTION_MENU_H__

#define __OPTION_MENU_H__

#include <gtk/gtk.h>
#include "typedefs.h"

/* Constant definitions */
#define OPTION_DEFAULT_CACHE_SIZE   320    /* 100KB (*100*1024) */
#define OPTION_SYSTEM_MIN_CACHE       1    /* 100KB (*100*1024) */
#define OPTION_SYSTEM_MAX_CACHE    9999    /* 100KB (*100*1024) */
#define	OPTION_DEFAULT_MAX_NUM      100
#define	OPTION_SYSTEM_MAX_NUM      9999
#define	OPTION_SYSTEM_MIN_NUM         1
#define	OPTION_SIMPLE_EDITOR_MAX   9999
#define	OPTION_SIMPLE_EDITOR_MIN      1
#define OPTION_DEFAULT_VIEWER       "display -size 480x320!"
/********************************************************************
#define OPTION_DEFAULT_VIEWER       "display -geometry '480x320>'"
********************************************************************/
#define OPTION_DEFAULT_EDITOR       "gimp"
#define OPTION_DEFAULT_PRINTER \
  "convert - ps2:- | gs -q -sDEVICE=stcolor -sOutputFile=- \
-dNOPAUSE - | lpr"
#define OPTION_DEFAULT_ROTATE_LEFT  "convert -rotate -90"
#define OPTION_DEFAULT_ROTATE_RIGHT "convert -rotate 90"
#define OPTION_VIEWER_WIDTH         480
#define OPTION_VIEWER_HEIGHT        480

enum EnumEntryType {
  VIEWER_ENTRY      ,
  EDITOR_ENTRY      ,
  PRINTER_ENTRY     ,
  ROTATE_LEFT_ENTRY ,
  ROTATE_RIGHT_ENTRY
};

/* Structure definitions */

/* Public function declarations. */
void option_menu_init_app_option_structure    (AppOption*  );

void option_menu_destroy_app_option_structure (AppOption*  );

void option_menu_read_config_file             (AppOption*  );

void option_menu_write_config_file            (AppOption*  );

void option_menu_cb_configuration             (GtkWidget*, 
                                               gpointer  ,
                                               guint       );

#endif  /* __OPTION_MENU_H__ */

