/*
 * Danpei -- a GTK+ based Image Viewer
 * Copyright (C) 2001-2003 Shinji Moiino
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* statusbar.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "config.h"
#include "statusbar.h"
#include "typedefs.h"
#include "utils.h"
#include "version.h"

/* Static functions declaration. */

/* Function definitions. */
/*
 * @statusbar_put_message
 *
 *  Put a string specified by the argument on the stasubar.
 *
 */
void statusbar_put_message(ManageStatusbar *statusbar,
                           gchar           *message    ){

  if (statusbar->bar == NULL) { return; }

  if (GTK_IS_WIDGET(statusbar->bar)) {
    statusbar_remove_message(statusbar);
    statusbar->context_id = 
               gtk_statusbar_get_context_id (GTK_STATUSBAR(statusbar->bar),
               "Statusbar Message");
    statusbar->message_id = 
               gtk_statusbar_push(GTK_STATUSBAR(statusbar->bar),
                                  statusbar->context_id, message);
  }

  return;
}

/*
 * @statusbar_remove_message
 *
 *  Remove the message on the stasubar.
 *
 */
void statusbar_remove_message(ManageStatusbar *statusbar) {
  if (!(GTK_IS_WIDGET(statusbar->bar))) { return; }

  if ((statusbar->context_id != 0) || 
      (statusbar->message_id != 0)    ) {
    gtk_statusbar_pop(GTK_STATUSBAR(statusbar->bar), statusbar->context_id);
    gtk_statusbar_remove(GTK_STATUSBAR(statusbar->bar), 
                         statusbar->context_id, statusbar->message_id);
    statusbar->context_id = statusbar->message_id = 0;
  }

  return;
}

/* Static function definitions. */


