//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//  based on exim/exiscan patch by Tom Kistner.
//  adapted by m4d.
//

#include "KAVScan.hpp"


extern OptionContainer o;


// Constructor
KAV5Engine::KAV5Engine ()
{
}

// Deconstructor
KAV5Engine::~KAV5Engine ()
{
};


int
KAV5Engine::scanFile (const char *_fname)
{
  int sock = 0;
  int infected = AV_CLEAN;
  struct sockaddr_un server;

#ifdef DGDEBUG
  cout << "Entering KAV5Engine scanFile" << endl;
  cout << "Before connect" << endl;
#endif

  //open the aveserver socket
  sock = socket (AF_UNIX, SOCK_STREAM, 0);
  if (sock < 0)
    {
#ifdef DGDEBUG
      cout << "socket creation failed" << endl;
#endif
      setErrString ("socket creation failed");
      return AV_FAIL;
    }

  server.sun_family = AF_UNIX;
  strcpy (server.sun_path, o.avesocket.c_str ());
  if (connect (sock, (struct sockaddr *) &server, sizeof (struct sockaddr_un)) < 0)
    {
      close (sock);
#ifdef DGDEBUG
      cout << "socket connect failed" << endl;
#endif
      setErrString ("socket connect failed");
      return AV_FAIL;
    }

  /* read aveserver's greeting and see if it is ready (2xx greeting) */
  char buf[32768];
  recv_line (sock, buf, sizeof (buf));

  if (buf[0] != '2')
    {
      /* aveserver is having problems */
      close (sock);
#ifdef DGDEBUG
      cout << "aveserver is unavailable (returned: " << ((buf[0] != 0) ? buf : (char *) "nothing") << ")" << endl;
#endif
      setErrString ("aveserver is unavailable");
      return AV_FAIL;
    };

  /* prepare our command */
  snprintf (buf, 32768, "SCAN bPQRSTUW %s\r\n", _fname);

  /* and send it */
  if (send (sock, buf, strlen (buf), 0) < 0)
    {
      close (sock);
#ifdef DGDEBUG
      cout << "unable to write to aveserver socket (" << o.avesocket << ")" << endl;
#endif
      setErrString ("unable to write to aveserver socket");
      return AV_FAIL;
    }

  /* read response lines, find malware name and final response */
  while (recv_line (sock, buf, 32768) > 0)
    {
#ifdef DGDEBUG
      cout << "aveserver response: " << buf << endl;
#endif
      if (buf[0] == '2')
        break;
      if (strncmp (buf, "322", 3) == 0)
        {
          char *p = strchr (&buf[4], ' ');
          *p = '\0';
          setVirusName (&buf[4]);
          infected = AV_VIRUS;
        };
    }
  close (sock);

  return infected;
}

/* simple wrapper for reading lines from sockets */
int
KAV5Engine::recv_line (int _sock, char *_buf, int _size)
{
  char *p = _buf;

  // clear buffer
  memset (_buf, 0, _size);

  // read until \n
  while (recv (_sock, p, 1, 0) > -1)
    {
      if ((p - _buf) > (_size - 2))
        break;
      if (*p == '\n')
        break;
      if (*p != '\r')
        p++;
    }
  *p = '\0';

  return p - _buf;
}
