#ifndef __HPP_VIRUSENGINE
#define __HPP_VIRUSENGINE

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//  Written by Aecio F. Neto(afn@harvest.com.br)
//              Harvest Consultoria (http://www.harvest.com.br)
//
//  and somewhat hacked by mad@madness.at ;-)
//

using namespace std;

// this is our abstract base class that specifies the av-engine api throughout dg
//
class VirusEngine
{
public:
  enum
  { AV_FAIL = -1, AV_CLEAN = 0, AV_VIRUS = 1 };

    VirusEngine ()
  {
  };
  virtual ~ VirusEngine ()
  {
  };

  virtual int loadEngine () = 0;
  virtual int reloadEngine () = 0;
  virtual int unloadEngine () = 0;

  virtual int scanFile (const char *_fname) = 0;

  virtual const char *getVirusName () = 0;
  virtual const char *getErrString () = 0;

  virtual void setVirusName (const char *_vname) = 0;
  virtual void setErrString (const char *_err_str) = 0;
};

#endif
