module Curl ( readUrlPS, copyUrl ) where

import IO
#ifdef HAVE_CURL
import Foreign.C.String ( withCString, CString )
import Monad ( when )
#endif

import FastPackedString ( PackedString, readFilePS )
import Lock ( withTemp )

readUrlPS :: String -> IO PackedString
readUrlPS u = withTemp $ \tf -> do copyUrl u tf
                                   readFilePS tf

copyUrl :: String -> String -> IO ()
#ifdef HAVE_CURL
copyUrl u f =
  withCString u $ \ustr ->
  withCString f $ \fstr -> do
  err <- get_curl fstr ustr
  when (err /= 0) $ fail $ "Failed to download URL "++ u ++ curl_e err
      where curl_e 1 = "libcurl: unsupported protocol"
            curl_e 3 = "libcurl: malformed URL"
            curl_e 6 = "libcurl: couldn't resolve host"
            curl_e 7 = "libcurl: couldn't connect to host"
            curl_e 22 = "libcurl: HTTP error (404?)"
            curl_e 23 = "libcurl write error"
            curl_e err = "libcurl error code: "++show err
#else
copyUrl _ _ = fail "There is no libcurl!"
#endif

#ifdef HAVE_CURL
foreign import ccall "hscurl.h get_curl"
  get_curl :: CString -> CString -> IO Int
#endif

