% Various utility functions that do not belong anywhere else.

\begin{code}

module DarcsUtils ( catchall, ortryrunning, bug,
                    putStrError, putStrLnError,
                    withCurrentDirectory ) where

import System ( ExitCode(..) )
import System.IO ( hPutStr, hPutStrLn, stderr )
import Control.Exception ( bracket )
import Directory ( setCurrentDirectory )
import Workaround ( getCurrentDirectory )
import Monad ( when )

catchall :: IO a -> IO a -> IO a
a `catchall` b = a `catch` (\ _-> b)

ortryrunning :: Monad m => m ExitCode -> m ExitCode -> m ExitCode
a `ortryrunning` b = do ret <- a
                        if ret == ExitSuccess
                           then return ret
                           else b

bug :: String -> a
bug s = error $ "bug in darcs!\n" ++ s ++
                "\nPlease report this to darcs-users@abridgegame.org"

putStrError :: String -> IO ()
putStrError = hPutStr stderr

putStrLnError :: String -> IO ()
putStrLnError = hPutStrLn stderr

withCurrentDirectory :: FilePath -> IO a -> IO a
withCurrentDirectory name m = 
    bracket 
        (do cwd <- getCurrentDirectory
            when (name /= "") (setCurrentDirectory name)
            return cwd)
        (\oldwd -> do setCurrentDirectory oldwd)
        (const m)
\end{code}
