%  Copyright (C) 2003 David Roundy
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software Foundation,
%  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

\begin{code}
module PrintPatch ( printPatch, contextualPrintPatch,
                  ) where

import System.IO

import Patch ( Patch, showContextPatch, showPatch )
import SlurpDirectory ( Slurpy )
import Printer (Printers, PChar,
                colourPrinters, escapedPrinters, putPrintStr)
\end{code}


\begin{code}

-- This specifies the type that Printer will use internally.  It can
-- be any subtype of Printable.

type PrinterType = PChar

ioPrinters :: Bool -> IO (Printers PrinterType)
ioPrinters True = colourPrinters
ioPrinters False = return escapedPrinters

printPatch :: Patch -> IO ()
printPatch p = do isterm <- hIsTerminalDevice stdout
                  printers <- ioPrinters isterm
                  putPrintStr $ showPatch printers p

contextualPrintPatch :: Slurpy -> Patch -> IO ()
contextualPrintPatch s p = do isterm <- hIsTerminalDevice stdout
                              printers <- ioPrinters isterm
                              putPrintStr $ showContextPatch printers s p
\end{code}
