#include <curl/curl.h>
#include <curl/easy.h>

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include "hscurl.h"

static CURL *c = NULL;
static int curl_init_done = 0;

// get_curl returns an error code
int get_curl(const char *filename, const char *url) {
  CURLcode err;
  FILE *f;
  if(!curl_init_done) {
      curl_global_init(CURL_GLOBAL_ALL);
      curl_init_done=1;
  }
  if (c == NULL) c = curl_easy_init();
  if (c == NULL) return -2;

  f = fopen(filename,"wb");
  if (f == NULL) return -1;

  err = curl_easy_setopt(c, CURLOPT_URL, url);
  /*curl_easy_setopt(c, CURLOPT_NOSIGNAL, NULL);*/
  err += curl_easy_setopt(c, CURLOPT_WRITEDATA, f);
  err += curl_easy_setopt(c, CURLOPT_FOLLOWLOCATION, 1);
  err += curl_easy_setopt(c, CURLOPT_FAILONERROR, 1);
  err += curl_easy_perform(c);
  fclose(f);
  return (int) err;
}

