#!/usr/bin/env perl

# Testing amend-record. 

use lib 'lib/perl';
use Test::More 'no_plan';
use strict;
use Test::Darcs;
use Shell::Command;
use File::Slurp;


init_tmp_repo();

# Plain amend-record
touch 'foo';
darcs "add foo";
like( darcs("record -a -m add_foo"), qr/finished recording/i, 'added patch');
append_file('foo',"\nanother line");

like( echo_to_darcs("amend-record -a foo","y"), qr/amending changes/i, 'amend-record -a');
is($?,0, " return code == 0");

{
  my $changes = darcs "changes -v";
  like( $changes, qr/another line/, 'change amended properly');
}

# amend-record of removed file
touch 'bar1' ;
touch 'bar2' ;
append_file('bar1',"a line\n");
append_file('bar1',"a line\n");
darcs("add bar1 bar2");
like( darcs("record -a -m add_bars"), qr/finished recording/i, 'added another patch');
rm_f('bar2');

like( echo_to_darcs("amend-record -a","y"), qr/finished amending/i, 'amend-record removed file');
is($?,0, " return code == 0");

# Special case: patch is empty after amend
cp "foo","foo.old";
append_file('foo',"\nanother line");

like( darcs("record -a -m add_line foo"), qr/finished recording/i, 'record');
mv "foo.old","foo";
like( echo_to_darcs("amend -a foo","y"), qr/amending changes/i, 'amend makes empty patch');
is($?,0, "  return code == 0");

# Amend --author, -m, etc
append_file('foo',"\nanother line");
like( echo_to_darcs("amend -a -m new_name foo","y"), qr/amending changes/i, 'amend');
like( darcs("changes --last=1"), qr/new_name/, 'amend can change patch name' );

append_file('foo',"\nanother line");

like( echo_to_darcs("amend -a -m new_name -A new_author foo","y"), qr/amending changes/i, 'amend');
like( darcs("changes --last=1"), qr/new_author/, 'amend can change patch author' );

