#!/usr/bin/env perl

# Some tests for darcs get
# in particular, we text --context with absolute paths, as reported in in issue227.

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use File::Slurp;
use Cwd 'abs_path';
use strict;

use File::Temp 'tempdir';
chdir tempdir( CLEANUP => 1 );

mkpath 'first';
chdir  'first';
darcs  'init';

touch 't.t';
darcs 'add t.t';
darcs 'record -am "initial add"';
my $context = darcs "changes --context";
ok($context,"got some context");

write_file('my_context.txt',$context) || die;

my $abs_to_context = abs_path('my_context.txt');  

chdir '../';

my $out = darcs "get first --context=$abs_to_context second";
like($out,qr/finished getting/i, "got expected success message when using absolute path with --context");



