#!/usr/bin/env bash

set -ev

rm -rf temp1
mkdir temp1
cd temp1
darcs init
touch foo
darcs add foo

# Check that prompting works as expected when answering yes...
echo yes | darcs whatsnew -s --prehook 'touch prehook-ran'
test -f prehook-ran
rm prehook-ran

# Check that prompting works as expected when answering no...
echo no | darcs whatsnew -s --prehook 'touch prehook-ran'
test ! -f prehook-ran

# Check that prompting works as expected with defaults (yes)...
echo ALL --prehook touch prehook-ran > _darcs/prefs/defaults
echo yes | darcs whatsnew -s
test -f prehook-ran
rm prehook-ran

# Check that prompting works as expected with defaults (no)...
echo no | darcs whatsnew -s
test ! -f prehook-ran

# Check that --run-prehook works in defaults
echo ALL --run-prehook >> _darcs/prefs/defaults
darcs whatsnew -s
test -f prehook-ran
rm prehook-ran

# Check that --run-prehook works when specified both in defaults and on
# command line
darcs whatsnew --run-prehook -s
test -f prehook-ran
rm prehook-ran

# Check that --prehook works when --run-prehook is in defaults
echo ALL --run-prehook > _darcs/prefs/defaults
darcs whatsnew --prehook 'touch prehook-ran' -s
test -f prehook-ran
rm prehook-ran

echo Successful.

cd ..
rm -rf temp1
