/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef DARKROOMVIEW_H
#define DARKROOMVIEW_H

#include <QGraphicsView>

class RawImageInfo;
class Darkroom;

/**
 * This is the main view class for Darkroom.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * @short Main view
 * @author Cyrille Berger <cberger@cberger.net>
 * @version 0.1
 */

class DarkroomView : public QGraphicsView
{
    Q_OBJECT
public:
    /**
     * Default constructor
     */
    DarkroomView(Darkroom *parent);

    /**
     * Destructor
     */
    virtual ~DarkroomView();
    void setRawImageInfo( RawImageInfo* v);
  public slots:
    void fileSaveAs();
    void zoomIn();
    void zoomOut();
    void actualSize();
    void fitToPage();
  signals:
    /**
     * Use this signal to change the content of the statusbar
     */
    void signalChangeStatusbar(const QString& text);

    /**
     * Use this signal to change the content of the caption
     */
    void signalChangeCaption(const QString& text);
  protected:
    void wheelEvent( QWheelEvent * event );
  public slots:
    void setImage( const QImage& );
    void updatePreview();
  private:
    void updateBatchProcessBox();
  private:
    struct Private;
    Private * const d;
};

#endif // DarkroomVIEW_H
