/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef _JOB_EXPORT_H_
#define _JOB_EXPORT_H_

#include <threadweaver/Job.h>

class PostProcessor;
class RawImageInfo;

namespace KDcrawIface {
  class RawDecodingSettings;
}

namespace ThreadWeaver {
  class Weaver;
};

class JobExport : public ThreadWeaver::Job {
  public:
    JobExport( RawImageInfo*, const QString& dstFileName, const KDcrawIface::RawDecodingSettings& settings, const PostProcessor& _processor);
    virtual ~JobExport();
    static ThreadWeaver::Weaver* weaver();
  protected:
    virtual void run();    
  private:
    struct Private;
    Private* const d;
};

#endif
