/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#include "JobThumbnail.h"

#include <QFileInfo>
#include <QImage>

#include <threadweaver/ThreadWeaver.h>

#include <libkdcraw/kdcraw.h>

#include "RawImageInfo.h"

struct JobThumbnail::Private
{
  RawImageInfo* rawImageInfo;
  static ThreadWeaver::Weaver* weaver;
};

ThreadWeaver::Weaver* JobThumbnail::Private::weaver = 0;

JobThumbnail::JobThumbnail( RawImageInfo* _rawImageInfo) : d(new Private)
{
  d->rawImageInfo = _rawImageInfo;
}

JobThumbnail::~JobThumbnail()
{
  delete d;
}

ThreadWeaver::Weaver* JobThumbnail::weaver()
{
  if(not Private::weaver)
  {
    Private::weaver = new ThreadWeaver::Weaver;
  }
  return Private::weaver;
}

void JobThumbnail::run()
{
  QImage img;
  KDcrawIface::KDcraw::loadDcrawPreview( img, d->rawImageInfo->fileInfo().absoluteFilePath() );
  img = img.scaledToWidth( 100 );
  d->rawImageInfo->setPreview(img );
}
