/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.ref.CoroutineManager;
import org.apache.xml.dtm.ref.CoroutineParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class CoroutineSAXParser
implements CoroutineParser,
Runnable,
ContentHandler,
LexicalHandler,
ErrorHandler {
    boolean DEBUG = false;
    private CoroutineManager fCoroutineManager = null;
    private int fAppCoroutineID = -1;
    private int fParserCoroutineID = -1;
    private boolean fParseInProgress = false;
    private XMLReader fXMLReader = null;
    private boolean fRunningInThread = false;
    private ContentHandler clientContentHandler = null;
    private LexicalHandler clientLexicalHandler = null;
    private ErrorHandler clientErrorHandler = null;
    private int eventcounter;
    private int frequency = 5;
    private boolean fNeverYieldAgain = false;
    final UserRequestedStopException stopException = new UserRequestedStopException();
    final UserRequestedShutdownException shutdownException = new UserRequestedShutdownException();

    public CoroutineSAXParser() {
    }

    public CoroutineSAXParser(CoroutineManager coroutineManager, int n) {
        this.init(coroutineManager, n, null);
    }

    public CoroutineSAXParser(CoroutineManager coroutineManager, int n, XMLReader xMLReader) {
        this.init(coroutineManager, n, xMLReader);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.characters(cArray, n, n2);
        }
    }

    private void co_yield(boolean bl) {
        block15: {
            Object object;
            if (this.fNeverYieldAgain) {
                return;
            }
            Object object2 = object = bl ? Boolean.TRUE : Boolean.FALSE;
            if (!bl) {
                if (this.fRunningInThread) {
                    return;
                }
                try {
                    object = this.fCoroutineManager.co_resume(Boolean.FALSE, this.fParserCoroutineID, this.fAppCoroutineID);
                    while (object != null) {
                        if (object == Boolean.TRUE) {
                            object = Boolean.FALSE;
                        } else {
                            System.err.println("Filtering CoroutineSAXParser: unexpected resume parameter, " + object.getClass() + " with value=\"" + object + '\"');
                            object = new RuntimeException("Filtering CoroutineSAXParser: unexpected resume parameter, " + object.getClass() + " with value=\"" + object + '\"');
                        }
                        object = this.fCoroutineManager.co_resume(object, this.fParserCoroutineID, this.fAppCoroutineID);
                    }
                    this.fCoroutineManager.co_exit_to(object, this.fParserCoroutineID, this.fAppCoroutineID);
                    return;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace(System.err);
                    this.fCoroutineManager.co_exit(this.fParserCoroutineID);
                    throw this.shutdownException;
                }
            }
            try {
                object = this.fCoroutineManager.co_resume(object, this.fParserCoroutineID, this.fAppCoroutineID);
                if (!this.fRunningInThread && object == Boolean.FALSE) {
                    this.clientContentHandler = null;
                    this.clientLexicalHandler = null;
                    this.fNeverYieldAgain = true;
                    object = this.fCoroutineManager.co_resume(Boolean.FALSE, this.fParserCoroutineID, this.fAppCoroutineID);
                    while (object != null) {
                        String string = "Filtering CoroutineSAXParser: unexpected resume parameter, " + object.getClass() + " with value=\"" + object + '\"';
                        System.err.println(string);
                        object = new RuntimeException(string);
                        object = this.fCoroutineManager.co_resume(object, this.fParserCoroutineID, this.fAppCoroutineID);
                    }
                    this.fCoroutineManager.co_exit_to(object, this.fParserCoroutineID, this.fAppCoroutineID);
                    return;
                }
                if (object == null) {
                    this.fCoroutineManager.co_exit_to(object, this.fParserCoroutineID, this.fAppCoroutineID);
                    throw new UserRequestedShutdownException();
                }
                if (object instanceof Boolean) {
                    boolean bl2 = (Boolean)object;
                    if (!bl2) {
                        throw this.stopException;
                    }
                    break block15;
                }
                System.err.println("Active CoroutineSAXParser: unexpected resume parameter, " + object.getClass() + " with value=\"" + object + '\"');
                System.err.println("\tStopping parser rather than risk deadlock");
                throw new RuntimeException(XSLMessages.createMessage(162, new Object[]{object}));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace(System.err);
                this.fCoroutineManager.co_exit(this.fParserCoroutineID);
                throw new UserRequestedShutdownException();
            }
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.comment(cArray, n, n2);
        }
    }

    void count_and_yield(boolean bl) {
        if (!bl) {
            this.eventcounter = 0;
        }
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
    }

    public Object doMore(boolean bl, int n) {
        try {
            Object object = this.fCoroutineManager.co_resume(bl ? Boolean.TRUE : Boolean.FALSE, n, this.fParserCoroutineID);
            if (object == null) {
                System.out.println("\nUNEXPECTED: Parser doMore says shut down prematurely.\n");
            } else if (object instanceof Exception) {
                System.out.println("\nParser threw exception:");
                ((Exception)object).printStackTrace();
            }
            return object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return noSuchMethodException;
        }
    }

    public Object doParse(InputSource inputSource, int n) {
        if (!this.fRunningInThread) {
            return Boolean.TRUE;
        }
        try {
            Object object = this.fCoroutineManager.co_resume(inputSource, n, this.fParserCoroutineID);
            if (object instanceof Exception) {
                if (object instanceof SAXException) {
                    SAXException sAXException = (SAXException)object;
                    Exception exception = sAXException.getException();
                    if (exception != null) {
                        exception.printStackTrace();
                    } else {
                        System.out.println("\nParser threw exception:");
                        sAXException.printStackTrace();
                    }
                } else {
                    System.out.println("\nParser threw exception:");
                    ((Exception)object).printStackTrace();
                }
            }
            return object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return noSuchMethodException;
        }
    }

    public void doTerminate(int n) {
        try {
            Object object = Boolean.FALSE;
            object = this.fCoroutineManager.co_resume(null, n, this.fParserCoroutineID);
            if (object != null) {
                RuntimeException runtimeException = new RuntimeException(XSLMessages.createMessage(163, new Object[]{object}));
                runtimeException.printStackTrace();
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    public void endCDATA() throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.endDTD();
        }
    }

    public void endDocument() throws SAXException {
        if (this.clientContentHandler != null) {
            this.clientContentHandler.endDocument();
        }
        this.eventcounter = 0;
        this.co_yield(false);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.endElement(string, string2, string3);
        }
    }

    public void endEntity(String string) throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.endEntity(string);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.endPrefixMapping(string);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.clientErrorHandler != null) {
            this.clientErrorHandler.error(sAXParseException);
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (!this.fRunningInThread) {
            try {
                this.fCoroutineManager.co_exit_to(sAXParseException, this.fParserCoroutineID, this.fAppCoroutineID);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace(System.err);
                this.fCoroutineManager.co_exit(this.fParserCoroutineID);
            }
        }
        if (this.clientErrorHandler != null) {
            this.clientErrorHandler.error(sAXParseException);
        }
    }

    public CoroutineManager getCoroutineManager() {
        return this.fCoroutineManager;
    }

    public int getParserCoroutineID() {
        return this.fParserCoroutineID;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void init(CoroutineManager coroutineManager, int n, XMLReader xMLReader) {
        this.fXMLReader = null;
        this.eventcounter = this.frequency;
        this.fCoroutineManager = coroutineManager;
        this.fAppCoroutineID = n;
        this.fParserCoroutineID = coroutineManager.co_joinCoroutineSet(-1);
        if (this.fParserCoroutineID == -1) {
            throw new RuntimeException(XSLMessages.createMessage(161, null));
        }
        this.fRunningInThread = false;
        if (xMLReader != null) {
            this.setXMLReader(xMLReader);
            this.fRunningInThread = true;
            TransformerImpl.runTransformThread(this);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.processingInstruction(string, string2);
        }
    }

    public void run() {
        try {
            Object object = this.fCoroutineManager.co_entry_pause(this.fParserCoroutineID);
            while (true) {
                block18: {
                    if (object == null) {
                        if (this.DEBUG) {
                            System.out.println("CoroutineSAXParser at-rest shutdown requested");
                        }
                        this.fCoroutineManager.co_exit_to(object, this.fParserCoroutineID, this.fAppCoroutineID);
                        break;
                    }
                    if (object instanceof InputSource) {
                        try {
                            if (this.DEBUG) {
                                System.out.println("Inactive CoroutineSAXParser new parse " + object);
                            }
                            this.fXMLReader.parse((InputSource)object);
                            object = Boolean.FALSE;
                        }
                        catch (SAXException sAXException) {
                            Exception exception = sAXException.getException();
                            if (exception instanceof UserRequestedStopException) {
                                if (this.DEBUG) {
                                    System.out.println("Active CoroutineSAXParser user stop exception");
                                }
                                object = Boolean.FALSE;
                                break block18;
                            }
                            if (exception instanceof UserRequestedShutdownException) {
                                if (this.DEBUG) {
                                    System.out.println("Active CoroutineSAXParser user shutdown exception");
                                }
                                break;
                            }
                            if (this.DEBUG) {
                                System.out.println("Active CoroutineSAXParser UNEXPECTED SAX exception: " + sAXException);
                            }
                            object = sAXException;
                        }
                        catch (Exception exception) {
                            if (this.DEBUG) {
                                System.out.println("Active CoroutineSAXParser non-SAX exception: " + exception);
                            }
                            object = exception;
                        }
                    } else {
                        System.err.println("Inactive CoroutineSAXParser: unexpected resume parameter, " + object.getClass() + " with value=\"" + object + '\"');
                        object = new RuntimeException("Inactive CoroutineSAXParser: unexpected resume parameter, " + object.getClass() + " with value=\"" + object + '\"');
                    }
                }
                object = this.fCoroutineManager.co_resume(object, this.fParserCoroutineID, this.fAppCoroutineID);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace(System.err);
            this.fCoroutineManager.co_exit(this.fParserCoroutineID);
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.clientContentHandler = contentHandler;
    }

    public void setDocumentLocator(Locator locator) {
        if (--this.eventcounter <= 0) {
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.setDocumentLocator(locator);
        }
    }

    public void setErrHandler(ErrorHandler errorHandler) {
        this.clientErrorHandler = errorHandler;
    }

    public void setLexHandler(LexicalHandler lexicalHandler) {
        this.clientLexicalHandler = lexicalHandler;
    }

    public void setReturnFrequency(int n) {
        if (n < 1) {
            n = 1;
        }
        this.frequency = this.eventcounter = n;
    }

    public void setXMLReader(XMLReader xMLReader) {
        if (this.fXMLReader != null) {
            return;
        }
        this.fXMLReader = xMLReader;
        this.fXMLReader.setContentHandler(this);
        this.fXMLReader.setErrorHandler(this);
        try {
            this.fXMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {}
    }

    public void skippedEntity(String string) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.skippedEntity(string);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.startCDATA();
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.startDTD(string, string2, string3);
        }
    }

    public void startDocument() throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.startDocument();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.startElement(string, string2, string3, attributes);
        }
    }

    public void startEntity(String string) throws SAXException {
        if (this.clientLexicalHandler != null) {
            this.clientLexicalHandler.startEntity(string);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.startPrefixMapping(string, string2);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.clientErrorHandler != null) {
            this.clientErrorHandler.error(sAXParseException);
        }
    }

    class UserRequestedStopException
    extends RuntimeException {
        UserRequestedStopException() {
        }
    }

    class UserRequestedShutdownException
    extends RuntimeException {
        UserRequestedShutdownException() {
        }
    }
}

