/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ChildTestIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;

public class OneStepIterator
extends ChildTestIterator {
    protected int m_axis = -1;
    protected DTMAxisIterator m_iterator;

    public OneStepIterator(DTMAxisIterator dTMAxisIterator, int n) throws TransformerException {
        super((DTMAxisTraverser)null);
        this.m_iterator = dTMAxisIterator;
        this.m_axis = n;
        int n2 = -1;
        this.initNodeTest(n2);
    }

    OneStepIterator(Compiler compiler, int n, int n2) throws TransformerException {
        super(compiler, n, n2);
        int n3 = OpMap.getFirstChildPos(n);
        this.m_axis = WalkerFactory.getAxisFromStep(compiler, n3);
    }

    public Object clone() throws CloneNotSupportedException {
        OneStepIterator oneStepIterator = (OneStepIterator)super.clone();
        if (this.m_iterator != null) {
            oneStepIterator.m_iterator = this.m_iterator.cloneIterator();
        }
        return oneStepIterator;
    }

    protected void countProximityPosition(int n) {
        if (!this.isReverseAxes()) {
            super.countProximityPosition(n);
        } else if (n < this.m_proximityPositions.length) {
            int n2 = n;
            this.m_proximityPositions[n2] = this.m_proximityPositions[n2] - 1;
        }
    }

    public int getAxis() {
        return this.m_axis;
    }

    public int getLastPos(XPathContext xPathContext) {
        if (!this.isReverseAxes()) {
            return super.getLastPos(xPathContext);
        }
        int n = 0;
        try {
            try {
                int n2;
                OneStepIterator oneStepIterator = (OneStepIterator)this.clone();
                int n3 = this.getRoot();
                xPathContext.pushCurrentNode(n3);
                oneStepIterator.setRoot(n3, xPathContext);
                oneStepIterator.setPredicateCount(this.getPredicateCount() - 1);
                while ((n2 = oneStepIterator.nextNode()) != -1) {
                    ++n;
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
            }
            Object var4_6 = null;
            xPathContext.popCurrentNode();
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            xPathContext.popCurrentNode();
            throw throwable;
        }
        return n;
    }

    protected int getNextNode() {
        this.m_lastFetched = this.m_iterator.next();
        return this.m_lastFetched;
    }

    protected int getProximityPosition(int n) {
        if (!this.isReverseAxes()) {
            return super.getProximityPosition(n);
        }
        if (n < 0) {
            return -1;
        }
        if (this.m_proximityPositions[n] <= 0) {
            XPathContext xPathContext = this.getXPathContext();
            try {
                try {
                    int n2;
                    OneStepIterator oneStepIterator = (OneStepIterator)this.clone();
                    int n3 = this.getRoot();
                    xPathContext.pushCurrentNode(n3);
                    oneStepIterator.setRoot(n3, xPathContext);
                    oneStepIterator.setPredicateCount(n);
                    int n4 = 1;
                    while ((n2 = oneStepIterator.nextNode()) != -1) {
                        ++n4;
                    }
                    int n5 = n;
                    this.m_proximityPositions[n5] = this.m_proximityPositions[n5] + n4;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                }
                Object var4_7 = null;
                xPathContext.popCurrentNode();
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                xPathContext.popCurrentNode();
                throw throwable;
            }
        }
        return this.m_proximityPositions[n];
    }

    public boolean isReverseAxes() {
        return this.m_iterator.isReverse();
    }

    public void reset() {
        super.reset();
        if (this.m_iterator != null) {
            this.m_iterator.reset();
        }
    }

    public void setRoot(int n, Object object) {
        super.setRoot(n, object);
        if (this.m_axis > -1) {
            this.m_iterator = this.m_cdtm.getAxisIterator(this.m_axis);
        }
        this.m_iterator.setStartNode(this.m_context);
    }
}

