/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.Expression;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathException;
import org.apache.xpath.objects.XMLStringFactoryImpl;
import org.apache.xpath.objects.XObjectFactory;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XObject
extends Expression
implements Serializable,
Cloneable {
    protected Object m_obj;
    public static final int CLASS_NULL = -1;
    public static final int CLASS_UNKNOWN = 0;
    public static final int CLASS_BOOLEAN = 1;
    public static final int CLASS_NUMBER = 2;
    public static final int CLASS_STRING = 3;
    public static final int CLASS_NODESET = 4;
    public static final int CLASS_RTREEFRAG = 5;
    public static final int CLASS_UNRESOLVEDVARIABLE = 600;

    public XObject() {
    }

    public XObject(Object object) {
        this.m_obj = object;
    }

    public void allowDetachToRelease(boolean bl) {
    }

    public void appendToFsb(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append(this.str());
    }

    public boolean bool() throws TransformerException {
        this.error(18, new Object[]{this.getTypeString()});
        return false;
    }

    public boolean boolWithSideEffects() throws TransformerException {
        return this.bool();
    }

    public Object castToType(int n, XPathContext xPathContext) throws TransformerException {
        Object object;
        switch (n) {
            case 3: {
                object = this.str();
                break;
            }
            case 2: {
                object = new Double(this.num());
                break;
            }
            case 4: {
                object = this.iter();
                break;
            }
            case 1: {
                object = new Boolean(this.bool());
                break;
            }
            case 0: {
                object = this.m_obj;
                break;
            }
            default: {
                this.error(21, new Object[]{this.getTypeString(), Integer.toString(n)});
                object = null;
            }
        }
        return object;
    }

    public static XObject create(Object object) {
        return XObjectFactory.create(object);
    }

    public static XObject create(Object object, XPathContext xPathContext) {
        return XObjectFactory.create(object, xPathContext);
    }

    public void destruct() {
        if (this.m_obj != null) {
            this.allowDetachToRelease(true);
            this.detach();
            this.m_obj = null;
        }
    }

    public void detach() {
    }

    public void dispatchCharactersEvents(ContentHandler contentHandler) throws SAXException {
        this.xstr().dispatchCharactersEvents(contentHandler);
    }

    public boolean equals(XObject xObject) {
        if (xObject.getType() == 4) {
            return xObject.equals(this);
        }
        if (this.m_obj != null) {
            return this.m_obj.equals(xObject.m_obj);
        }
        return xObject.m_obj == null;
    }

    protected void error(int n) throws TransformerException {
        this.error(n, null);
    }

    protected void error(int n, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHMessage(n, objectArray);
        throw new XPathException(string);
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        return this;
    }

    public void fixupVariables(Vector vector, int n) {
    }

    public int getType() {
        return 0;
    }

    public String getTypeString() {
        return "#UNKNOWN (" + this.object().getClass().getName() + ")";
    }

    public boolean greaterThan(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.lessThan(this);
        }
        return this.num() > xObject.num();
    }

    public boolean greaterThanOrEqual(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.lessThanOrEqual(this);
        }
        return this.num() >= xObject.num();
    }

    public DTMIterator iter() throws TransformerException {
        this.error(19, new Object[]{this.getTypeString()});
        return null;
    }

    public boolean lessThan(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.greaterThan(this);
        }
        return this.num() < xObject.num();
    }

    public boolean lessThanOrEqual(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.greaterThanOrEqual(this);
        }
        return this.num() <= xObject.num();
    }

    public NodeSetDTM mutableNodeset() throws TransformerException {
        this.error(20, new Object[]{this.getTypeString()});
        return (NodeSetDTM)this.m_obj;
    }

    public NodeList nodelist() throws TransformerException {
        this.error(19, new Object[]{this.getTypeString()});
        return null;
    }

    public NodeIterator nodeset() throws TransformerException {
        this.error(19, new Object[]{this.getTypeString()});
        return null;
    }

    public boolean notEquals(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.notEquals(this);
        }
        return this.equals(xObject) ^ true;
    }

    public double num() throws TransformerException {
        this.error(18, new Object[]{this.getTypeString()});
        return 0.0;
    }

    public double numWithSideEffects() throws TransformerException {
        return this.num();
    }

    public Object object() {
        return this.m_obj;
    }

    public int rtf() {
        return -1;
    }

    public int rtf(XPathContext xPathContext) {
        int n = this.rtf();
        if (n == -1) {
            DTM dTM = xPathContext.createDocumentFragment();
            dTM.appendTextChild(this.str());
            n = dTM.getDocument();
        }
        return n;
    }

    public DocumentFragment rtree() {
        return null;
    }

    public DocumentFragment rtree(XPathContext xPathContext) {
        DocumentFragment documentFragment = null;
        int n = this.rtf();
        if (n == -1) {
            DTM dTM = xPathContext.createDocumentFragment();
            dTM.appendTextChild(this.str());
            documentFragment = (DocumentFragment)dTM.getNode(dTM.getDocument());
        } else {
            DTM dTM = xPathContext.getDTM(n);
            documentFragment = (DocumentFragment)dTM.getNode(dTM.getDocument());
        }
        return documentFragment;
    }

    public String str() {
        return this.m_obj != null ? this.m_obj.toString() : "";
    }

    public String toString() {
        return this.str();
    }

    public XMLString xstr() {
        return XMLStringFactoryImpl.getFactory().newstr(this.str());
    }
}

