/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.Serializable;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.CommentStripper;
import net.sf.saxon.event.Sender;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetStripper;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.TreeBuilder;
import org.xml.sax.SAXParseException;

public class PreparedStyleSheet
implements Templates,
Serializable {
    private Executable executable;
    private transient Configuration config;
    private NamePool targetNamePool;
    private transient StyleNodeFactory nodeFactory;
    private int errorCount = 0;

    protected PreparedStyleSheet(Configuration configuration) {
        this.config = configuration;
    }

    public Transformer newTransformer() {
        Controller controller = new Controller(this.config);
        controller.setPreparedStyleSheet(this);
        return controller;
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getTargetNamePool() {
        return this.targetNamePool;
    }

    public StyleNodeFactory getStyleNodeFactory() {
        return this.nodeFactory;
    }

    protected void prepare(Source source) throws TransformerConfigurationException {
        this.nodeFactory = new StyleNodeFactory(this.config.getNamePool(), this.config.isAllowExternalFunctions());
        DocumentImpl documentImpl = PreparedStyleSheet.loadStylesheetModule(source, this.config, this.config.getNamePool(), this.nodeFactory);
        this.setStyleSheetDocument(documentImpl, this.nodeFactory);
        if (this.errorCount > 0) {
            throw new TransformerConfigurationException("Failed to compile stylesheet. " + this.errorCount + (this.errorCount == 1 ? " error " : " errors ") + "detected.");
        }
    }

    public static DocumentImpl loadStylesheetModule(Source source, Configuration configuration, NamePool namePool, StyleNodeFactory styleNodeFactory) throws TransformerConfigurationException {
        DocumentImpl documentImpl;
        StylesheetStripper stylesheetStripper = new StylesheetStripper();
        stylesheetStripper.setStylesheetRules(namePool);
        TreeBuilder treeBuilder = new TreeBuilder();
        treeBuilder.setConfiguration(configuration);
        treeBuilder.setSystemId(source.getSystemId());
        treeBuilder.setNodeFactory(styleNodeFactory);
        treeBuilder.setLineNumbering(true);
        stylesheetStripper.setUnderlyingReceiver(treeBuilder);
        CommentStripper commentStripper = new CommentStripper();
        commentStripper.setUnderlyingReceiver(stylesheetStripper);
        try {
            Sender sender = new Sender(configuration);
            AugmentedSource augmentedSource = AugmentedSource.makeAugmentedSource(source);
            augmentedSource.setSchemaValidation(Boolean.FALSE);
            if (augmentedSource.getXMLReader() == null) {
                augmentedSource.setXMLReader(configuration.getStyleParser());
            }
            sender.send(augmentedSource, commentStripper);
            documentImpl = (DocumentImpl)treeBuilder.getCurrentDocument();
        }
        catch (TransformerException transformerException) {
            Throwable throwable = transformerException.getException();
            if (throwable != null) {
                if (throwable instanceof SAXParseException) {
                    SAXParseException sAXParseException = (SAXParseException)throwable;
                    if ((throwable = sAXParseException.getException()) != null) {
                        if (throwable instanceof TransformerConfigurationException) {
                            throw (TransformerConfigurationException)throwable;
                        }
                        if (throwable instanceof RuntimeException) {
                            throwable.printStackTrace();
                        }
                        throw new TransformerConfigurationException(throwable);
                    }
                    throw new TransformerConfigurationException("Failed to parse stylesheet");
                }
                if (throwable instanceof TransformerConfigurationException) {
                    throw (TransformerConfigurationException)throwable;
                }
                throw new TransformerConfigurationException(throwable);
            }
            throw new TransformerConfigurationException(transformerException);
        }
        if (documentImpl.getDocumentElement() == null) {
            throw new TransformerConfigurationException("Stylesheet is empty or absent");
        }
        return documentImpl;
    }

    protected void setStyleSheetDocument(DocumentImpl documentImpl, StyleNodeFactory styleNodeFactory) throws TransformerConfigurationException {
        StyleElement styleElement;
        DocumentImpl documentImpl2 = documentImpl;
        this.nodeFactory = styleNodeFactory;
        if (this.targetNamePool == null) {
            this.targetNamePool = NamePool.getDefaultNamePool();
        }
        if ((styleElement = (StyleElement)documentImpl2.getDocumentElement()) instanceof LiteralResultElement) {
            documentImpl2 = ((LiteralResultElement)styleElement).makeStyleSheet(this, styleNodeFactory);
        }
        if (!(documentImpl2.getDocumentElement() instanceof XSLStyleSheet)) {
            throw new TransformerConfigurationException("Top-level element of stylesheet is not xsl:stylesheet or xsl:transform or literal result element");
        }
        XSLStyleSheet xSLStyleSheet = (XSLStyleSheet)documentImpl2.getDocumentElement();
        xSLStyleSheet.setPreparedStyleSheet(this);
        xSLStyleSheet.preprocess();
        this.executable = xSLStyleSheet.compileStyleSheet();
        this.executable.setConfiguration(this.config);
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public Properties getOutputProperties() {
        Properties properties = this.executable.getDefaultOutputProperties();
        return new Properties(properties);
    }

    public void reportError(TransformerException transformerException) throws TransformerException {
        ++this.errorCount;
        this.config.getErrorListener().error(transformerException);
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void reportWarning(TransformerException transformerException) {
        try {
            this.config.getErrorListener().warning(transformerException);
        }
        catch (TransformerException transformerException2) {}
    }
}

