/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.DocumentInfo;

public class TransformerReceiver
extends ProxyReceiver {
    Controller controller;
    Builder builder;
    Result result;
    String systemId;

    public TransformerReceiver(Controller controller) {
        this.controller = controller;
        this.setConfiguration(controller.getConfiguration());
        this.builder = controller.makeBuilder();
        this.builder.setConfiguration(controller.getConfiguration());
        Stripper stripper = controller.makeStripper(this.builder);
        this.setUnderlyingReceiver(stripper);
    }

    public Transformer getTransformer() {
        return this.controller;
    }

    public void setSystemId(String string) {
        this.systemId = string;
        this.builder.setSystemId(string);
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        super.startElement(n, n2, n3);
    }

    public void setResult(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("Result must not be null");
        }
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public void endDocument() throws TransformerException {
        super.endDocument();
        DocumentInfo documentInfo = this.builder.getCurrentDocument();
        if (documentInfo == null) {
            throw new TransformerException("No source document has been built");
        }
        documentInfo.getNamePool().allocateDocumentNumber(documentInfo);
        this.controller.transformDocument(documentInfo, this.result);
    }
}

