/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ConvertToString;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.UntypedAtomicConverter;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class TypeChecker {
    public static Expression staticTypeCheck(Expression expression, SequenceType sequenceType, boolean bl, RoleLocator roleLocator) throws XPathException.Type {
        boolean bl2;
        boolean bl3;
        Expression expression2 = expression;
        ItemType itemType = sequenceType.getPrimaryType();
        int n = sequenceType.getCardinality();
        boolean bl4 = Cardinality.allowsMany(n);
        ItemType itemType2 = null;
        int n2 = -1;
        boolean bl5 = bl3 = n == 1792;
        if (!bl3) {
            n2 = expression2.getCardinality();
            bl3 = Cardinality.subsumes(n, n2);
        }
        if (!(bl2 = sequenceType.getPrimaryType() instanceof AnyItemType) && !(bl2 = Type.isSubType(itemType2 = expression2.getItemType(), itemType)) && Type.isPromotable(itemType2, itemType)) {
            bl2 = true;
            expression2 = new CastExpression(expression2, (AtomicType)itemType, true);
            itemType2 = itemType;
        }
        if (bl2 && bl3) {
            return expression2;
        }
        if (n2 == -1) {
            n2 = expression2.getCardinality();
        }
        if (itemType2 == null) {
            itemType2 = expression2.getItemType();
        }
        if (n2 == 256 && (n & 0x100) == 0) {
            throw new XPathException.Type("An empty sequence is not allowed as the " + roleLocator.getMessage(), ExpressionTool.getLocator(expression));
        }
        if (bl && !bl4) {
            if (Type.isSubType(itemType, Type.STRING_TYPE)) {
                if (!Type.isSubType(itemType2, Type.ANY_ATOMIC_TYPE)) {
                    expression2 = new Atomizer(expression2);
                    ExpressionTool.copyLocationInfo(expression, expression2);
                }
                expression2 = new ConvertToString(expression2);
                ExpressionTool.copyLocationInfo(expression, expression2);
                itemType2 = Type.STRING_TYPE;
                n2 = 512;
            } else if (itemType == Type.NUMBER_TYPE || Type.isSubType(itemType, Type.DOUBLE_TYPE)) {
                NumberFn numberFn = (NumberFn)SystemFunction.makeSystemFunction("number");
                Expression[] expressionArray = new Expression[]{expression2};
                numberFn.setArguments(expressionArray);
                expression2 = numberFn;
                ExpressionTool.copyLocationInfo(expression, expression2);
                itemType2 = Type.DOUBLE_TYPE;
                n2 = 512;
            } else if (itemType instanceof AnyNodeTest || itemType instanceof AnyItemType || itemType == Type.ANY_ATOMIC_TYPE) {
                if (Cardinality.allowsMany(n2)) {
                    expression2 = new FirstItemExpression(expression2);
                    ExpressionTool.copyLocationInfo(expression, expression2);
                }
                n2 = 768;
            }
        }
        if (itemType instanceof AtomicType && !(itemType2 instanceof AtomicType)) {
            expression2 = new Atomizer(expression2);
            ExpressionTool.copyLocationInfo(expression, expression2);
            itemType2 = expression2.getItemType();
            n2 = expression2.getCardinality();
        }
        if (itemType != Type.ANY_ATOMIC_TYPE && itemType instanceof AtomicType && itemType2 instanceof AtomicType && ((AtomicType)itemType2 == Type.ANY_ATOMIC_TYPE || (AtomicType)itemType2 == Type.UNTYPED_ATOMIC_TYPE)) {
            expression2 = new UntypedAtomicConverter(expression2, (AtomicType)itemType);
            ExpressionTool.copyLocationInfo(expression, expression2);
            itemType2 = expression2.getItemType();
            n2 = expression2.getCardinality();
        }
        if (!(Type.isSubType(itemType2, itemType) || !(expression2 instanceof Value) && Type.isSubType(itemType, itemType2) || itemType instanceof NodeTest && itemType2 instanceof NodeTest)) {
            throw new XPathException.Type("Required type of " + roleLocator.getMessage() + " is " + itemType + "; supplied value has type " + itemType2, ExpressionTool.getLocator(expression));
        }
        if (!bl2) {
            if (expression2 instanceof Value) {
                throw new XPathException.Type("Required type of " + roleLocator.getMessage() + " is " + itemType + "; supplied value has type " + itemType2, ExpressionTool.getLocator(expression));
            }
            expression2 = new ItemChecker(expression2, itemType, roleLocator);
            ExpressionTool.copyLocationInfo(expression, expression2);
        }
        if (!bl3) {
            if (expression2 instanceof Value) {
                throw new XPathException.Type("Required cardinality of " + roleLocator.getMessage() + " is " + Cardinality.toString(n) + "; supplied value has cardinality " + Cardinality.toString(n2), ExpressionTool.getLocator(expression));
            }
            expression2 = new CardinalityChecker(expression2, n, roleLocator);
            ExpressionTool.copyLocationInfo(expression, expression2);
        }
        return expression2;
    }
}

