/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.Err;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class ResolveURI
extends SystemFunction {
    String expressionBaseURI = null;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        this.expressionBaseURI = staticContext.getBaseURI();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        URI uRI;
        URI uRI2;
        String string = this.argument[0].evaluateAsString(xPathContext);
        try {
            uRI2 = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.dynamicError("Relative URI " + Err.wrap(string) + " is invalid: " + uRISyntaxException.getMessage());
            return null;
        }
        if (uRI2.isAbsolute()) {
            return new StringValue(string);
        }
        String string2 = this.getNumberOfArguments() == 2 ? this.argument[1].evaluateAsString(xPathContext) : this.expressionBaseURI;
        try {
            uRI = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.dynamicError("Base URI " + Err.wrap(string2) + " is invalid: " + uRISyntaxException.getMessage());
            return null;
        }
        if (!uRI.isAbsolute()) {
            this.dynamicError("Base URI " + Err.wrap(string2) + " is not an absolute URI");
            return null;
        }
        URI uRI3 = uRI.resolve(uRI2);
        return new StringValue(uRI3.toString());
    }
}

