/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.Loader;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.number.NumberFormatter;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.number.Numberer_en;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class NumberInstruction
extends Instruction {
    private static final int SINGLE = 0;
    private static final int MULTI = 1;
    private static final int ANY = 2;
    private static final int SIMPLE = 3;
    private int level;
    private Pattern count = null;
    private Pattern from = null;
    private Expression select = null;
    private Expression value = null;
    private Expression format = null;
    private Expression groupSize = null;
    private Expression groupSeparator = null;
    private Expression letterValue = null;
    private Expression ordinal = null;
    private Expression lang = null;
    private NumberFormatter formatter = null;
    private Numberer numberer = null;
    private boolean hasVariablesInPatterns;
    private static Numberer defaultNumberer = new Numberer_en();

    public NumberInstruction(Expression expression, int n, Pattern pattern, Pattern pattern2, Expression expression2, Expression expression3, Expression expression4, Expression expression5, Expression expression6, Expression expression7, Expression expression8, NumberFormatter numberFormatter, Numberer numberer, boolean bl) {
        this.select = expression;
        this.level = n;
        this.count = pattern;
        this.from = pattern2;
        this.value = expression2;
        this.format = expression3;
        this.groupSize = expression4;
        this.groupSeparator = expression5;
        this.letterValue = expression6;
        this.ordinal = expression7;
        this.lang = expression8;
        this.formatter = numberFormatter;
        this.numberer = numberer;
        this.hasVariablesInPatterns = bl;
        if (this.value != null && !Type.isSubType(this.value.getItemType(), Type.ANY_ATOMIC_TYPE)) {
            this.value = new Atomizer(this.value);
        }
    }

    public String getInstructionName() {
        return "number";
    }

    public ItemType getItemType() {
        return NodeKindTest.TEXT;
    }

    public int getCardinality() {
        return 512;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        long l = -1L;
        List<Long> list = null;
        if (this.value != null) {
            object4 = this.value.iterate(xPathContext);
            list = new ArrayList<String>();
            while ((object3 = (AtomicValue)object4.next()) != null) {
                try {
                    object2 = object3 instanceof NumericValue ? (NumericValue)object3 : NumberFn.convert((AtomicValue)object3);
                    object2 = ((NumericValue)object2).round();
                    if (((NumericValue)object2).compareTo(IntegerValue.MAX_LONG) > 0) {
                        throw new XPathException.Dynamic("A number is too large to be formatted");
                    }
                    if (((NumericValue)object2).compareTo(IntegerValue.MIN_LONG) < 0) {
                        throw new XPathException.Dynamic("The numbers to be formatted must be positive");
                    }
                    long l2 = ((NumericValue)((AtomicValue)object2).convert(532)).asLong();
                    if (l2 < 1L) {
                        throw new XPathException.Dynamic("The numbers to be formatted must be positive");
                    }
                    list.add(new Long(l2));
                }
                catch (XPathException xPathException) {
                    list.add((Long)((Object)((Value)object3).getStringValue()));
                    Instruction.recoverableError(this, xPathException.getMessage(), controller);
                }
            }
        } else {
            if (this.select != null) {
                object4 = (NodeInfo)this.select.evaluateItem(xPathContext);
            } else {
                object3 = controller.getCurrentItem();
                if (!(object3 instanceof NodeInfo)) {
                    Instruction.recoverableError(this, "context item for xsl:number must be a node", controller);
                    return null;
                }
                object4 = (NodeInfo)object3;
            }
            if (this.level == 3) {
                l = Navigator.getNumberSimple((NodeInfo)object4, controller);
            } else if (this.level == 0) {
                l = Navigator.getNumberSingle((NodeInfo)object4, this.count, this.from, controller);
                if (l == 0L) {
                    list = new ArrayList();
                }
            } else if (this.level == 2) {
                l = Navigator.getNumberAny(this, (NodeInfo)object4, this.count, this.from, controller, this.hasVariablesInPatterns);
                if (l == 0L) {
                    list = new ArrayList();
                }
            } else if (this.level == 1) {
                list = Navigator.getNumberMulti((NodeInfo)object4, this.count, this.from, controller);
            }
        }
        int n = 0;
        object3 = "";
        String string = null;
        if (this.groupSize != null) {
            object = this.groupSize.evaluateAsString(xPathContext);
            try {
                n = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.dynamicError("group-size must be numeric", controller);
            }
        }
        if (this.groupSeparator != null) {
            object3 = this.groupSeparator.evaluateAsString(xPathContext);
        }
        if (this.ordinal != null) {
            string = this.ordinal.evaluateAsString(xPathContext);
        }
        if (list == null && this.format == null && n == 0 && this.lang == null) {
            sequenceReceiver.characters("" + l, 0);
            return null;
        }
        if (this.numberer == null) {
            this.numberer = NumberInstruction.makeNumberer(this.lang.evaluateAsString(xPathContext));
        }
        if (this.letterValue == null) {
            object2 = "";
        } else {
            object2 = this.letterValue.evaluateAsString(xPathContext);
            if (!((String)object2).equals("alphabetic") && !((String)object2).equals("traditional")) {
                throw this.dynamicError("letter-value must be \"traditional\" or \"alphabetic\"", controller);
            }
        }
        if (list == null) {
            list = new ArrayList();
            list.add(new Long(l));
        }
        if (this.formatter == null) {
            object = new NumberFormatter();
            ((NumberFormatter)object).prepare(this.format.evaluateAsString(xPathContext));
        } else {
            object = this.formatter;
        }
        String string2 = ((NumberFormatter)object).format(list, n, (String)object3, (String)object2, string, this.numberer);
        sequenceReceiver.characters(string2, 0);
        return null;
    }

    public static Numberer makeNumberer(String string) {
        Numberer numberer;
        if (string.equals("en")) {
            numberer = defaultNumberer;
        } else {
            String string2 = "net.sf.saxon.number.Numberer_";
            int n = 0;
            while (n < string.length()) {
                if (Character.isLetter(string.charAt(n))) {
                    string2 = string2 + string.charAt(n);
                }
                ++n;
            }
            try {
                numberer = (Numberer)Loader.getInstance(string2);
            }
            catch (Exception exception) {
                numberer = defaultNumberer;
            }
        }
        return numberer;
    }
}

