/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.Serializable;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.SequenceInstruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trace.TraceListener;

public class Template
implements Serializable {
    private SequenceInstruction body;
    private int precedence;
    private int minImportPrecedence;
    private boolean needsStackFrame;
    private String systemId;
    private int lineNumber;
    private InstructionDetails details = null;

    public void init(SequenceInstruction sequenceInstruction, boolean bl, int n, int n2, String string, int n3) {
        this.body = sequenceInstruction;
        this.needsStackFrame = bl;
        this.precedence = n;
        this.minImportPrecedence = n2;
        this.systemId = string;
        this.lineNumber = n3;
    }

    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
        instructionDetails.setInstructionName("template");
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public boolean needsStackFrame() {
        return this.needsStackFrame;
    }

    public void process(Controller controller) throws TransformerException {
        TailCall tailCall = this.processLeavingTail(controller);
        while (tailCall != null) {
            tailCall = tailCall.processLeavingTail(controller);
        }
    }

    public TailCall processLeavingTail(Controller controller) throws TransformerException {
        if (this.body == null) {
            return null;
        }
        Template template = controller.getCurrentTemplate();
        controller.setCurrentTemplate(this);
        TailCall tailCall = controller.isTracing() ? this.traceExpand(controller) : this.body.processLeavingTail(controller.newXPathContext());
        controller.setCurrentTemplate(template);
        return tailCall;
    }

    protected TailCall traceExpand(Controller controller) throws TransformerException {
        TraceListener traceListener = controller.getTraceListener();
        if (this.details == null) {
            this.details = new InstructionDetails();
            this.details.setSystemId(this.systemId);
            this.details.setLineNumber(this.lineNumber);
            this.details.setInstructionName("template");
            this.details.setProperty("controller", controller);
        }
        traceListener.enter(this.details);
        TailCall tailCall = this.expand(controller);
        traceListener.leave(this.details);
        return tailCall;
    }

    protected TailCall expand(Controller controller) throws TransformerException {
        if (this.body == null) {
            return null;
        }
        return this.body.processLeavingTail(controller.newXPathContext());
    }
}

