/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Comparator;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.FunctionProxy;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Type;
import net.sf.saxon.xpath.XPathException;

public class ExpressionContext
implements StaticContext {
    private StyleElement element;
    private NamePool namePool;

    public ExpressionContext(StyleElement styleElement) {
        this.element = styleElement;
        this.namePool = styleElement.getTargetNamePool();
    }

    public Configuration getConfiguration() {
        return this.element.getPreparedStyleSheet().getConfiguration();
    }

    public void issueWarning(String string) {
        this.element.issueWarning(string);
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public String getSystemId() {
        return this.element.getSystemId();
    }

    public int getLineNumber() {
        return this.element.getLineNumber();
    }

    public String getBaseURI() {
        return this.element.getBaseURI();
    }

    public String getURIForPrefix(String string) throws XPathException {
        try {
            return this.element.getURIForPrefix(string, false);
        }
        catch (NamespaceException namespaceException) {
            throw new XPathException.Static(namespaceException);
        }
    }

    public NamespaceContext getNamespaceContext() {
        return this.element.makeNamespaceContext();
    }

    public int getFingerprint(String string, boolean bl) throws XPathException {
        String[] stringArray;
        try {
            stringArray = Name.getQNameParts(string);
        }
        catch (QNameException qNameException) {
            throw new XPathException.Static(qNameException.getMessage());
        }
        String string2 = stringArray[0];
        if (string2.equals("")) {
            String string3 = "";
            if (bl) {
                string3 = this.getURIForPrefix(string2);
            }
            return this.namePool.getFingerprint(string3, string);
        }
        String string4 = this.getURIForPrefix(string2);
        return this.namePool.getFingerprint(string4, stringArray[1]);
    }

    public VariableDeclaration bindVariable(int n) throws XPathException.Static {
        return this.element.bindVariable(n);
    }

    public Expression bindFunction(String string, Expression[] expressionArray) throws XPathException {
        Class clazz;
        int n;
        XSLFunction xSLFunction;
        boolean bl;
        String string2;
        block25: {
            SourceLocator sourceLocator;
            int n2;
            String string3;
            String string4;
            Object object;
            try {
                object = Name.getQNameParts(string);
                string4 = object[0];
                string3 = this.getURIForPrefix(object[0]);
                string2 = object[1];
            }
            catch (QNameException qNameException) {
                throw new XPathException.Dynamic("Invalid function name: " + qNameException);
            }
            if (string4.equals("") || string3.equals("http://www.w3.org/2003/11/xpath-functions")) {
                object = SystemFunction.makeSystemFunction(string2);
                if (object == null) {
                    return new ErrorExpression(new XPathException.Dynamic("Unknown system function: " + string));
                }
                ((FunctionCall)object).setArguments(expressionArray);
                return object;
            }
            bl = this.element.getPreparedStyleSheet().getConfiguration().isTraceExternalFunctions();
            if (bl) {
                System.err.println("Resolving external function call to " + string);
            }
            if ((xSLFunction = this.getStyleSheetFunction(n = (n2 = this.namePool.allocate(string4, string3, string2)) & 0xFFFFF, expressionArray.length)) != null && xSLFunction.isOverriding()) {
                if (bl) {
                    System.err.println("Found a stylesheet function with override='yes'");
                }
                UserFunctionCall userFunctionCall = new UserFunctionCall();
                xSLFunction.registerReference(userFunctionCall);
                userFunctionCall.setFingerprint(n);
                userFunctionCall.setArguments(expressionArray);
                return userFunctionCall;
            }
            if (n == this.namePool.getFingerprint("http://saxon.sf.net/", "evaluate")) {
                FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:evaluate");
                functionCall.setArguments(expressionArray);
                return functionCall;
            }
            if (n == this.namePool.getFingerprint("http://saxon.sf.net/", "expression")) {
                FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:expression");
                functionCall.setArguments(expressionArray);
                return functionCall;
            }
            if (n == this.namePool.getFingerprint("http://saxon.sf.net/", "eval")) {
                FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:eval");
                functionCall.setArguments(expressionArray);
                return functionCall;
            }
            if (n == this.namePool.getFingerprint("http://saxon.sf.net/", "parse")) {
                FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:parse");
                functionCall.setArguments(expressionArray);
                return functionCall;
            }
            if (n == this.namePool.getFingerprint("http://saxon.sf.net/", "serialize")) {
                FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:serialize");
                functionCall.setArguments(expressionArray);
                return functionCall;
            }
            if (string3.equals("http://www.w3.org/2001/XMLSchema") || string3.equals("http://www.w3.org/2001/XMLSchema-datatypes") || string3.equals("http://www.w3.org/2003/11/xpath-datatypes")) {
                if (expressionArray.length != 1) {
                    throw new XPathException.Static("A constructor function must have exactly one argument");
                }
                AtomicType atomicType = (AtomicType)Type.getBuiltInItemType(string3, string2);
                if (atomicType == null) {
                    return new ErrorExpression(new XPathException.Dynamic("Unknown constructor function: " + string));
                }
                if (bl) {
                    System.err.println("Found a constructor for a built-in atomic type");
                }
                return new CastExpression(expressionArray[0], atomicType, false);
            }
            if (expressionArray.length == 1 && (sourceLocator = this.getConfiguration().getSchemaType(n)) != null && sourceLocator instanceof AtomicType) {
                return new CastExpression(expressionArray[0], (AtomicType)sourceLocator, false);
            }
            sourceLocator = this.element.getPrincipalStyleSheet();
            XQueryFunction xQueryFunction = ((XSLStyleSheet)sourceLocator).bindXQueryFunction(n);
            if (xQueryFunction != null) {
                UserFunctionCall userFunctionCall = new UserFunctionCall();
                xQueryFunction.registerReference(userFunctionCall);
                userFunctionCall.setFingerprint(n);
                userFunctionCall.setArguments(expressionArray);
                return userFunctionCall;
            }
            clazz = null;
            try {
                clazz = this.getExternalJavaClass(string3);
            }
            catch (Exception exception) {
                if (!bl) break block25;
                System.err.println("Failed to load a Java class for URI " + string3 + ": " + exception.getMessage());
            }
        }
        if (clazz != null) {
            FunctionProxy functionProxy = new FunctionProxy();
            functionProxy.setConfiguration(this.element.getPreparedStyleSheet().getConfiguration());
            if (bl) {
                System.err.println("Found a Java class");
            }
            functionProxy.setArguments(expressionArray);
            functionProxy.setFunctionName(clazz, string2, expressionArray.length);
            return functionProxy;
        }
        if (xSLFunction != null) {
            if (bl) {
                System.err.println("Found a stylesheet function with override='no'");
            }
            UserFunctionCall userFunctionCall = new UserFunctionCall();
            xSLFunction.registerReference(userFunctionCall);
            userFunctionCall.setFingerprint(n);
            userFunctionCall.setArguments(expressionArray);
            return userFunctionCall;
        }
        if (bl) {
            System.err.println("Failed to find any function matching " + string);
        }
        return new ErrorExpression(new XPathException.Dynamic("No function found matching " + string + " with " + this.showArgumentCount(expressionArray.length)));
    }

    private String showArgumentCount(int n) {
        if (n == 0) {
            return "no arguments";
        }
        if (n == 1) {
            return "one argument";
        }
        return n + " arguments";
    }

    private XSLFunction getStyleSheetFunction(int n, int n2) {
        return this.element.getStyleSheetFunction(n, n2);
    }

    private Class getExternalJavaClass(String string) throws TransformerException {
        XSLStyleSheet xSLStyleSheet = this.element.getPrincipalStyleSheet();
        Class clazz = xSLStyleSheet.getExternalJavaClass(string);
        if (clazz != null) {
            return clazz;
        }
        clazz = FunctionProxy.getVendorExtensionClass(string);
        if (clazz != null) {
            return clazz;
        }
        if (!xSLStyleSheet.getPreparedStyleSheet().getConfiguration().isAllowExternalFunctions()) {
            throw new TransformerException("Calls to external functions have been disabled");
        }
        return FunctionProxy.getImplicitJavaClass(string);
    }

    public boolean isElementAvailable(String string) throws XPathException {
        try {
            String[] stringArray = Name.getQNameParts(string);
            String string2 = this.getURIForPrefix(stringArray[0]);
            return this.element.getPreparedStyleSheet().getStyleNodeFactory().isElementAvailable(string2, stringArray[1]);
        }
        catch (QNameException qNameException) {
            throw new XPathException.Static("Invalid element name. " + qNameException.getMessage());
        }
    }

    public boolean isFunctionAvailable(String string, long l) throws XPathException {
        try {
            Object object;
            int n;
            String[] stringArray = Name.getQNameParts(string);
            String string2 = this.getURIForPrefix(stringArray[0]);
            String string3 = stringArray[1];
            if (stringArray[0].equals("") || string2.equals("http://www.w3.org/2003/11/xpath-functions")) {
                StandardFunction.Entry entry = StandardFunction.getFunction(string3);
                return entry != null && (l == -1L || l >= (long)entry.minArguments && l <= (long)entry.maxArguments);
            }
            if (string2.equals("http://saxon.sf.net/")) {
                if (string3.equals("evaluate")) {
                    return l < 0L || l > 0L;
                }
                if (string3.equals("expression")) {
                    return l < 0L || l == 1L;
                }
                if (string3.equals("eval")) {
                    return l < 0L || l > 0L;
                }
                if (string3.equals("parse")) {
                    return l < 0L || l == 1L;
                }
                if (string3.equals("serialize")) {
                    return l < 0L || l == 2L;
                }
            }
            if ((n = this.getFingerprint(string, false)) >= 0 && (object = this.getStyleSheetFunction(n, (int)l)) != null) {
                return true;
            }
            object = this.getExternalJavaClass(string2);
            if (object == null) {
                return false;
            }
            FunctionProxy functionProxy = new FunctionProxy();
            return functionProxy.setFunctionName((Class)object, string3, (int)l);
        }
        catch (QNameException qNameException) {
            throw new XPathException.Static("Invalid function name. " + qNameException.getMessage());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Comparator getCollation(String string) throws XPathException {
        return this.element.getPrincipalStyleSheet().findCollation(string);
    }

    public String getDefaultCollationName() {
        return this.element.getPrincipalStyleSheet().getDefaultCollationName();
    }

    public short getDefaultElementNamespace() {
        return this.element.getDefaultXPathNamespace();
    }

    public boolean isInBackwardsCompatibleMode() {
        return this.element.backwardsCompatibleModeIsEnabled();
    }

    public boolean isImportedSchema(String string) {
        return this.getXSLStyleSheet().isImportedSchema(string);
    }

    public XSLStyleSheet getXSLStyleSheet() {
        return this.element.getPrincipalStyleSheet();
    }

    public StyleElement getStyleElement() {
        return this.element;
    }
}

