/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.style.Procedure;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLAttribute;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.xpath.XPathException;

public class XSLAttributeSet
extends StyleElement {
    int fingerprint;
    String use;
    Procedure procedure = new Procedure();
    List attributeSetElements = null;
    AttributeSet[] useAttributeSets = null;
    AttributeSet instruction = new AttributeSet();
    int referenceCount = 0;
    boolean validated = false;

    public int getAttributeSetFingerprint() {
        return this.fingerprint;
    }

    public AttributeSet getInstruction() {
        return this.instruction;
    }

    public void incrementReferenceCount() {
        ++this.referenceCount;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        this.use = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string2 = this.getNamePool().getClarkName(n2);
            if (string2 == "name") {
                string = attributeCollection.getValue(n).trim();
            } else if (string2 == "use-attribute-sets") {
                this.use = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        try {
            this.fingerprint = this.makeNameCode(string.trim()) & 0xFFFFF;
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException.getMessage());
        }
    }

    public void validate() throws TransformerConfigurationException {
        Object object;
        if (this.validated) {
            return;
        }
        this.checkTopLevel();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((object = axisIterator.next()) != null) {
            if (object instanceof XSLAttribute) continue;
            this.compileError("Only xsl:attribute is allowed within xsl:attribute-set");
        }
        if (this.use != null) {
            this.attributeSetElements = new ArrayList();
            this.useAttributeSets = this.getAttributeSets(this.use, this.attributeSetElements);
            object = this.attributeSetElements.iterator();
            while (object.hasNext()) {
                ((XSLAttributeSet)object.next()).checkCircularity(this);
            }
        }
        this.validated = true;
    }

    public void checkCircularity(XSLAttributeSet xSLAttributeSet) throws TransformerConfigurationException {
        if (this == xSLAttributeSet) {
            this.compileError("The definition of the attribute set is circular");
        } else {
            if (!this.validated) {
                return;
            }
            if (this.attributeSetElements != null) {
                Iterator iterator = this.attributeSetElements.iterator();
                while (iterator.hasNext()) {
                    ((XSLAttributeSet)iterator.next()).checkCircularity(xSLAttributeSet);
                }
            }
        }
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    public Instruction compile(Executable executable) throws TransformerConfigurationException {
        if (this.referenceCount > 0) {
            this.getPrincipalStyleSheet().allocateLocalSlots(this.procedure.getNumberOfVariables());
            boolean bl = this.procedure.getNumberOfVariables() > 0;
            Block block = new Block();
            this.compileChildren(executable, block);
            this.instruction.initialize(this.useAttributeSets, block, bl);
            return null;
        }
        return null;
    }
}

