/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Element;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.FixedElement;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.StringValue;

public class XSLElement
extends StyleElement {
    private Expression elementName;
    private Expression namespace = null;
    private String use;
    private AttributeSet[] attributeSets = null;
    private int validation;
    private SchemaType schemaType = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string5 = this.getNamePool().getClarkName(n2);
            if (string5 == "name") {
                string = attributeCollection.getValue(n).trim();
            } else if (string5 == "namespace") {
                string2 = attributeCollection.getValue(n);
            } else if (string5 == "validation") {
                string3 = attributeCollection.getValue(n).trim();
            } else if (string5 == "type") {
                string4 = attributeCollection.getValue(n).trim();
            } else if (string5 == "use-attribute-sets") {
                this.use = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
        } else {
            this.elementName = this.makeAttributeValueTemplate(string);
            if (this.elementName instanceof StringValue && !Name.isQName(string)) {
                this.compileError("Element name is not a valid QName");
                this.elementName = new StringValue("saxon-error-element");
            }
        }
        if (string2 != null) {
            this.namespace = this.makeAttributeValueTemplate(string2);
        }
        if (string3 != null) {
            this.validation = Validation.getCode(string3);
            if (this.validation != 4 && !this.getConfiguration().isSchemaAware()) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed");
            }
            if (this.validation == -1) {
                this.compileError("Invalid value for validation attribute. Permitted values are (strict, lax, preserve, strip)");
            }
        } else {
            this.validation = this.getContainingStyleSheet().getDefaultValidation();
        }
        if (string4 != null) {
            if (!this.getConfiguration().isSchemaAware()) {
                this.compileError("The type attribute is available only with a schema-aware XSLT processor");
            }
            this.schemaType = this.getSchemaType(string4);
        }
        if (string4 != null && string3 != null) {
            this.compileError("validation and type attributes are mutually exclusive");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        if (this.use != null) {
            this.attributeSets = this.getAttributeSets(this.use, null);
        }
        this.elementName = this.typeCheck("name", this.elementName);
        this.namespace = this.typeCheck("namespace", this.namespace);
    }

    public Instruction compile(Executable executable) throws TransformerConfigurationException {
        Object object;
        NamespaceContext namespaceContext = null;
        if (this.elementName instanceof StringValue) {
            String[] stringArray;
            object = ((StringValue)this.elementName).getStringValue();
            try {
                stringArray = Name.getQNameParts((String)object);
            }
            catch (QNameException qNameException) {
                this.compileError("Invalid element name: " + (String)object);
                return null;
            }
            String string = null;
            if (this.namespace instanceof StringValue) {
                string = ((StringValue)this.namespace).getStringValue();
                if (string.equals("")) {
                    stringArray[0] = "";
                }
            } else if (this.namespace == null) {
                try {
                    string = this.getURIForPrefix(stringArray[0], true);
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage());
                    return null;
                }
            }
            if (string != null) {
                int n = this.getTargetNamePool().allocate(stringArray[0], string, stringArray[1]);
                FixedElement fixedElement = new FixedElement(n, null, this.attributeSets, this.schemaType, this.validation);
                this.compileChildren(executable, fixedElement);
                return fixedElement;
            }
        } else if (this.namespace == null) {
            namespaceContext = this.makeNamespaceContext();
        }
        object = new Element(this.elementName, this.namespace, namespaceContext, this.attributeSets, this.schemaType, this.validation);
        this.compileChildren(executable, (Instruction)object);
        return object;
    }
}

