/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.NodeImpl;
import org.w3c.dom.Node;

final class NamespaceImpl
extends NodeImpl {
    private int nsCode;
    private int nameCode;
    private int index;

    public NamespaceImpl(ElementImpl elementImpl, int n, int n2) {
        this.parent = elementImpl;
        this.nsCode = n;
        NamePool namePool = this.getNamePool();
        this.nameCode = namePool.allocate("", "", namePool.getPrefixFromNamespaceCode(n));
        this.index = n2;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public int getNamespaceCode() {
        return this.nsCode;
    }

    public boolean isSameNode(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof NamespaceImpl)) {
            return false;
        }
        if (this == nodeInfo) {
            return true;
        }
        NamespaceImpl namespaceImpl = (NamespaceImpl)nodeInfo;
        return this.parent.isSameNode(namespaceImpl.parent) && this.nsCode == namespaceImpl.nsCode;
    }

    public String getLocalPart() {
        return this.getNamePool().getPrefixFromNamespaceCode(this.nsCode);
    }

    public final int getNodeKind() {
        return 13;
    }

    public String getStringValue() {
        return this.getNamePool().getURIFromNamespaceCode(this.nsCode);
    }

    public String getNodeName() {
        return this.getLocalPart();
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public NodeImpl getPreviousInDocument() {
        return (NodeImpl)this.getParent();
    }

    public NodeImpl getNextInDocument(NodeImpl nodeImpl) {
        if (this == nodeImpl) {
            return null;
        }
        return ((NodeImpl)this.getParent()).getNextInDocument(nodeImpl);
    }

    public String getBaseURI() {
        return null;
    }

    public String generateId() {
        return this.parent.generateId() + "ns" + this.getLocalPart().hashCode();
    }

    public void copy(Receiver receiver, int n) throws TransformerException {
        receiver.namespace(this.nsCode, 32);
    }

    protected long getSequenceNumber() {
        return this.parent.getSequenceNumber() + (long)this.index;
    }
}

