/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.xpath.XPathException;

public final class BigIntegerValue
extends NumericValue {
    private BigInteger value;
    private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger ZERO = BigInteger.valueOf(0L);
    static /* synthetic */ Class class$net$sf$saxon$value$IntegerValue;
    static /* synthetic */ Class class$java$math$BigInteger;

    public BigIntegerValue(BigInteger bigInteger) {
        this.value = bigInteger;
    }

    public BigIntegerValue(long l) {
        this.value = BigInteger.valueOf(l);
    }

    public static NumericValue makeValue(BigInteger bigInteger) {
        if (bigInteger.compareTo(MAX_LONG) > 0 || bigInteger.compareTo(MIN_LONG) < 0) {
            return new BigIntegerValue(bigInteger);
        }
        return new IntegerValue(bigInteger.longValue());
    }

    public int hashCode() {
        if (this.value.compareTo(MIN_INT) >= 0 && this.value.compareTo(MAX_INT) <= 0) {
            return this.value.intValue();
        }
        return new Double(this.asDouble()).hashCode();
    }

    public long asLong() {
        return this.value.longValue();
    }

    public boolean isWithinLongRange() {
        return this.value.compareTo(MIN_LONG) >= 0 && this.value.compareTo(MAX_LONG) <= 0;
    }

    public BigDecimal asDecimal() {
        return new BigDecimal(this.value);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.value.compareTo(BigInteger.ZERO) != 0;
    }

    public int compareTo(Object object) {
        if (object instanceof BigIntegerValue) {
            return this.value.compareTo(((BigIntegerValue)object).value);
        }
        if (object instanceof DecimalValue) {
            return this.asDecimal().compareTo(((DecimalValue)object).getValue());
        }
        return super.compareTo(object);
    }

    public AtomicValue convert(int n) throws XPathException {
        switch (n) {
            case 514: {
                return BooleanValue.get(this.effectiveBooleanValue(null));
            }
            case 88: 
            case 532: 
            case 535: 
            case 643: 
            case 646: {
                return this;
            }
            case 533: 
            case 534: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: {
                if (this.isWithinLongRange()) {
                    return new IntegerValue(this.asLong(), (AtomicType)BuiltInSchemaFactory.getSchemaType(n));
                }
            }
            case 517: {
                return new DoubleValue(this.value.doubleValue());
            }
            case 516: {
                return new FloatValue(this.value.floatValue());
            }
            case 515: {
                return new DecimalValue(new BigDecimal(this.value));
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        throw new XPathException.Dynamic("Cannot convert integer to " + StandardNames.getDisplayName(n));
    }

    public String getStringValue() {
        return this.value.toString();
    }

    public NumericValue negate() {
        return new BigIntegerValue(this.value.negate());
    }

    public NumericValue floor() {
        return this;
    }

    public NumericValue ceiling() {
        return this;
    }

    public NumericValue round() {
        return this;
    }

    public NumericValue roundToHalfEven(int n) {
        if (n >= 0) {
            return this;
        }
        BigInteger bigInteger = BigInteger.valueOf(10L).pow(-n);
        BigInteger[] bigIntegerArray = this.value.divideAndRemainder(bigInteger);
        int n2 = bigIntegerArray[1].compareTo(bigInteger.divide(BigInteger.valueOf(2L)));
        if (n2 > 0) {
            bigIntegerArray[0] = bigIntegerArray[0].add(BigInteger.valueOf(1L));
        } else if (n2 == 0 && bigIntegerArray[0].mod(BigInteger.valueOf(2L)).signum() != 0) {
            bigIntegerArray[0] = bigIntegerArray[0].add(BigInteger.valueOf(1L));
        }
        return BigIntegerValue.makeValue(bigIntegerArray[0].multiply(bigInteger));
    }

    public boolean isWholeNumber() {
        return true;
    }

    public NumericValue arithmetic(int n, NumericValue numericValue) throws XPathException {
        if (numericValue instanceof BigIntegerValue) {
            BigInteger bigInteger = ((BigIntegerValue)numericValue).value;
            switch (n) {
                case 15: {
                    return BigIntegerValue.makeValue(this.value.add(bigInteger));
                }
                case 16: {
                    return BigIntegerValue.makeValue(this.value.subtract(bigInteger));
                }
                case 17: {
                    return BigIntegerValue.makeValue(this.value.multiply(bigInteger));
                }
                case 50: {
                    return BigIntegerValue.makeValue(this.value.divide(bigInteger));
                }
                case 18: {
                    DecimalValue decimalValue = new DecimalValue(new BigDecimal(this.value));
                    DecimalValue decimalValue2 = new DecimalValue(new BigDecimal(bigInteger));
                    return decimalValue.arithmetic(n, decimalValue2);
                }
                case 19: {
                    return BigIntegerValue.makeValue(this.value.remainder(bigInteger));
                }
            }
            throw new UnsupportedOperationException("Unknown operator");
        }
        if (numericValue instanceof IntegerValue) {
            BigIntegerValue bigIntegerValue = new BigIntegerValue(numericValue.asLong());
            return this.arithmetic(n, bigIntegerValue);
        }
        NumericValue numericValue2 = (NumericValue)this.convert(numericValue.getItemType().getPrimitiveType());
        return numericValue2.arithmetic(n, numericValue);
    }

    public ItemType getItemType() {
        return Type.INTEGER_TYPE;
    }

    public int conversionPreference(Class clazz, Configuration configuration) {
        return new IntegerValue(382L).conversionPreference(clazz, configuration);
    }

    public Object convertToJava(Class clazz, Configuration configuration) throws XPathException {
        if (this.isWithinLongRange()) {
            IntegerValue integerValue = new IntegerValue(this.asLong());
            return integerValue.convertToJava(clazz, configuration);
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$IntegerValue == null ? (class$net$sf$saxon$value$IntegerValue = BigIntegerValue.class$("net.sf.saxon.value.IntegerValue")) : class$net$sf$saxon$value$IntegerValue)) {
            return this;
        }
        if (clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = BigIntegerValue.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return this.value;
        }
        return this.convert(515).convertToJava(clazz, configuration);
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "BigInteger (" + this.getStringValue() + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

