/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public abstract class SequenceValue
extends Value {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$om$SequenceIterator;
    static /* synthetic */ Class class$net$sf$saxon$value$SequenceValue;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$org$w3c$dom$NodeList;
    static /* synthetic */ Class class$net$sf$saxon$om$NodeInfo;
    static /* synthetic */ Class class$org$w3c$dom$Node;

    public ItemType getItemType() {
        return AnyItemType.getInstance();
    }

    public int getCardinality() {
        try {
            SequenceIterator sequenceIterator = this.iterate(null);
            Item item = sequenceIterator.next();
            if (item == null) {
                return 256;
            }
            if (sequenceIterator.next() != null) {
                return 1536;
            }
            return 512;
        }
        catch (XPathException xPathException) {
            return 1792;
        }
    }

    public Item itemAt(int n) throws XPathException {
        Item item;
        if (n < 0) {
            return null;
        }
        int n2 = 0;
        SequenceIterator sequenceIterator = this.iterate(null);
        do {
            if ((item = sequenceIterator.next()) != null) continue;
            return null;
        } while (n2++ != n);
        return item;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this.iterate(xPathContext).next();
    }

    public String getStringValue() throws XPathException {
        StringBuffer stringBuffer = new StringBuffer();
        SequenceIterator sequenceIterator = this.iterate(null);
        Item item = sequenceIterator.next();
        if (item != null) {
            while (true) {
                stringBuffer.append(item.getStringValue());
                item = sequenceIterator.next();
                if (item == null) break;
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return "";
        }
        return atomicValue.getStringValue();
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.iterate(xPathContext);
        Item item = sequenceIterator.next();
        if (item == null) {
            return false;
        }
        if (item instanceof NodeInfo) {
            return true;
        }
        if (item instanceof BooleanValue) {
            return ((BooleanValue)item).getValue() || sequenceIterator.next() != null;
        }
        if (item instanceof StringValue) {
            return !item.getStringValue().equals("") || sequenceIterator.next() != null;
        }
        if (item instanceof NumericValue) {
            return sequenceIterator.next() != null || !item.equals(DoubleValue.ZERO) && item.equals(item);
        }
        return true;
    }

    public int conversionPreference(Class clazz, Configuration configuration) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = SequenceValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$om$SequenceIterator == null ? (class$net$sf$saxon$om$SequenceIterator = SequenceValue.class$("net.sf.saxon.om.SequenceIterator")) : class$net$sf$saxon$om$SequenceIterator)) {
            return -10;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$SequenceValue == null ? (class$net$sf$saxon$value$SequenceValue = SequenceValue.class$("net.sf.saxon.value.SequenceValue")) : class$net$sf$saxon$value$SequenceValue)) {
            return -9;
        }
        if (clazz.isAssignableFrom(class$java$util$List == null ? (class$java$util$List = SequenceValue.class$("java.util.List")) : class$java$util$List)) {
            return -8;
        }
        if (clazz.isAssignableFrom(class$org$w3c$dom$NodeList == null ? (class$org$w3c$dom$NodeList = SequenceValue.class$("org.w3c.dom.NodeList")) : class$org$w3c$dom$NodeList)) {
            return -7;
        }
        try {
            SequenceIterator sequenceIterator = this.iterate(null);
            Item item = sequenceIterator.next();
            if (item == null) {
                return Integer.MAX_VALUE;
            }
            if (item instanceof NodeInfo) {
                return SequenceValue.nodeToJavaPreference((NodeInfo)item, clazz, configuration);
            }
            return ((AtomicValue)item).conversionPreference(clazz, configuration);
        }
        catch (XPathException xPathException) {
            return Integer.MAX_VALUE;
        }
    }

    public static int nodeToJavaPreference(NodeInfo nodeInfo, Class clazz, Configuration configuration) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = SequenceValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if ((class$net$sf$saxon$om$NodeInfo == null ? (class$net$sf$saxon$om$NodeInfo = SequenceValue.class$("net.sf.saxon.om.NodeInfo")) : class$net$sf$saxon$om$NodeInfo).isAssignableFrom(clazz)) {
            return 6;
        }
        if ((class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = SequenceValue.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node).isAssignableFrom(clazz)) {
            return 7;
        }
        try {
            SequenceIterator sequenceIterator = nodeInfo.getTypedValue(configuration);
            AtomicValue atomicValue = (AtomicValue)sequenceIterator.next();
            if (atomicValue == null) {
                return Integer.MAX_VALUE;
            }
            return atomicValue.conversionPreference(clazz, configuration);
        }
        catch (XPathException xPathException) {
            return Integer.MAX_VALUE;
        }
    }

    public Object convertToJava(Class clazz, Configuration configuration) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = SequenceValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.iterate(null);
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$SequenceValue == null ? (class$net$sf$saxon$value$SequenceValue = SequenceValue.class$("net.sf.saxon.value.SequenceValue")) : class$net$sf$saxon$value$SequenceValue)) {
            return this;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$om$SequenceIterator == null ? (class$net$sf$saxon$om$SequenceIterator = SequenceValue.class$("net.sf.saxon.om.SequenceIterator")) : class$net$sf$saxon$om$SequenceIterator)) {
            return this.iterate(null);
        }
        if (clazz.isAssignableFrom(class$java$util$List == null ? (class$java$util$List = SequenceValue.class$("java.util.List")) : class$java$util$List)) {
            ArrayList<Item> arrayList = new ArrayList<Item>();
            SequenceIterator sequenceIterator = this.iterate(null);
            while (true) {
                Item item;
                if ((item = sequenceIterator.next()) == null) {
                    return arrayList;
                }
                arrayList.add(item);
            }
        }
        if (clazz.isAssignableFrom(class$org$w3c$dom$NodeList == null ? (class$org$w3c$dom$NodeList = SequenceValue.class$("org.w3c.dom.NodeList")) : class$org$w3c$dom$NodeList)) {
            if (this instanceof SequenceExtent) {
                return new DOMNodeList((SequenceExtent)this);
            }
            SequenceExtent sequenceExtent = new SequenceExtent(this.iterate(null));
            return new DOMNodeList(sequenceExtent);
        }
        SequenceIterator sequenceIterator = this.iterate(null);
        Item item = sequenceIterator.next();
        if (item != null) {
            if (item instanceof NodeInfo) {
                Object object;
                if (clazz.isAssignableFrom(item.getClass())) {
                    return item;
                }
                Object object2 = item;
                while (object2 instanceof VirtualNode) {
                    object = ((VirtualNode)object2).getUnderlyingNode();
                    if (clazz.isAssignableFrom(object.getClass())) {
                        return object;
                    }
                    object2 = object;
                }
                object = (AtomicValue)item.getTypedValue(configuration).next();
                if (object == null) {
                    return null;
                }
                return ((AtomicValue)object).convertToJava(clazz, configuration);
            }
            return ((AtomicValue)item).convertToJava(clazz, configuration);
        }
        return null;
    }

    public void display(int n, NamePool namePool) {
        try {
            Item item;
            System.err.println(ExpressionTool.indent(n) + "sequence of " + this.getItemType().toString() + " (");
            SequenceIterator sequenceIterator = this.iterate(null);
            while ((item = sequenceIterator.next()) != null) {
                ((ComputedExpression)((Object)item)).display(n + 1, namePool);
            }
            System.err.println(ExpressionTool.indent(n) + ")");
        }
        catch (Exception exception) {}
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

