<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="2.0"
    xmlns:lxslt="http://xml.apache.org/xslt">

  <!--
       Use DashboardStamp as a parameter, default to most recent
       The proper flags to Xalan are in the form -PARAM DashboardStamp "string('foo')"
       -->
 <xsl:param name="DashboardPath"/> 
 <xsl:param name="DashboardStamp" select="string('MostRecentResults-Nightly')"/>
 <xsl:param name="TestDocDir">.</xsl:param>
 <xsl:variable name="DashboardDir" select="concat('../../../../Dashboard/', $DashboardStamp)"/>
 <xsl:variable name="IconDir">../../../../Icons</xsl:variable>
 <xsl:include href="DashboardConfig.xsl"/>
 <!-- This style sheet outputs 4 HTML files and 1 XML file we need to decide
      on an output method that will work with all the files.  Here are are 
      choosing "html" since we do not want the UTF-8 encoding that comes
      by default with "xml" output.  If the output method is "xml", then
      special symbols like &shy; get corrupted on output. The other option
      is to not set the output "method" but set the output "encoding"
      as "iso-8859-1"-->
 <xsl:output method="html"/>

  <xsl:template match="/">
    Coverage.html is deliberately empty.  Separate coverage reports sorted by name, count and status are generated.
    <xsl:call-template name="Summary"/>
    <xsl:call-template name="CoverageByName"/>
    <xsl:call-template name="CoverageByCount"/>
    <xsl:call-template name="CoverageByUntested"/>
    <xsl:call-template name="CoverageByStatus"/>
 </xsl:template>


 <xsl:template name="CoverageByName">
   <xsl:variable name="uri" select="concat('file:///', $TestDocDir, '/CoverageByName.html' )"/>
  <xsl:result-document href="{$uri}">
    <xsl:call-template name="DashboardHeader">
      <xsl:with-param name="Title">Coverage Log</xsl:with-param>
      <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
      <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
    </xsl:call-template>

  <xsl:call-template name="SummaryTable"/>
 <br/><br/> 
  <table>
      <tr>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></th>
        <th colspan="2">Coverage status ( <a href="CoverageByStatus.html">sort by</a> )</th>
      </tr>
      <tr>
        <th>Filename <img border="0"><xsl:attribute name="src"><xsl:value-of select="$IconDir"/>/DownBlack.gif</xsl:attribute></img></th>
        <th>Percentage ( <a href="CoverageByCount.html">sort by</a> )</th>
        <th>Lines not covered ( <a href="CoverageByUntested.html">sort by</a> )</th> 
      </tr>
      <xsl:for-each select="Site/Coverage/File">
        <xsl:sort select="@Covered" order="descending"/>
        <xsl:sort select="@FullPath"/>
        <xsl:call-template name="File"/>
      </xsl:for-each>
    </table>
    <xsl:call-template name="DashboardFooter">
	<xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
    </xsl:call-template>
 </xsl:result-document> 
 </xsl:template>

 <xsl:template name="CoverageByCount">
   <xsl:variable name="uri" select="concat('file:///', $TestDocDir, '/CoverageByCount.html' )"/>
  <xsl:result-document href="{$uri}">
    <xsl:call-template name="DashboardHeader">
      <xsl:with-param name="Title">Coverage Log</xsl:with-param>
      <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
      <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
    </xsl:call-template>

  <xsl:call-template name="SummaryTable"/>
  <br/><br/> 
  <table>
      <tr>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></th>
        <th colspan="2">Coverage status ( <a href="CoverageByStatus.html">sort by</a> )</th>
      </tr>
      <tr>
        <th>Filename ( <a href="CoverageByName.html">sort by</a> )</th> 
        <th>Percentage <img border="0"><xsl:attribute name="src"><xsl:value-of select="$IconDir"/>/DownBlack.gif</xsl:attribute></img></th> 
        <th>Lines not covered ( <a href="CoverageByUntested.html">sort by</a> )</th> 
      </tr>
      <xsl:for-each select="Site/Coverage/File">
        <xsl:sort select="@Covered" order="ascending"/>
        <xsl:sort select="PercentCoverage" data-type="number" order="ascending"/>
        <xsl:call-template name="File"/>
      </xsl:for-each>
    </table>
    <xsl:call-template name="DashboardFooter">
	<xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
    </xsl:call-template>
  </xsl:result-document>  
 </xsl:template>

 <xsl:template name="CoverageByUntested">
   <xsl:variable name="uri" select="concat('file:///', $TestDocDir, '/CoverageByUntested.html' )"/>
  <xsl:result-document href="{$uri}" >
    <xsl:call-template name="DashboardHeader">
      <xsl:with-param name="Title">Coverage Log</xsl:with-param>
      <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
      <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
    </xsl:call-template>

  <xsl:call-template name="SummaryTable"/>
  <br/><br/> 
  <table>
      <tr>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></th>
        <th colspan="2">Coverage status ( <a href="CoverageByStatus.html">sort by</a> )</th>
      </tr>
      <tr>
        <th>Filename ( <a href="CoverageByName.html">sort by</a> )</th> 
        <th>Percentage ( <a href="CoverageByCount.html">sort by</a> )</th>
        <th>Lines not covered  <img border="0"><xsl:attribute name="src"><xsl:value-of select="$IconDir"/>/DownBlack.gif</xsl:attribute></img></th> 
      </tr>
      <xsl:for-each select="Site/Coverage/File">
        <xsl:sort select="@Covered" order="ascending"/>
        <xsl:sort select="LOCUnTested" data-type="number" order="descending"/>
        <xsl:call-template name="File"/>
      </xsl:for-each>
    </table>
    <xsl:call-template name="DashboardFooter">
	<xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
    </xsl:call-template>
  </xsl:result-document>  
 </xsl:template>

 <xsl:template name="CoverageByStatus">
   <xsl:variable name="uri" select="concat('file:///', $TestDocDir, '/CoverageByStatus.html' )"/>
  <xsl:result-document href="{$uri}" >
    <xsl:call-template name="DashboardHeader">
      <xsl:with-param name="Title">Coverage Log</xsl:with-param>
      <xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
      <xsl:with-param name="DashboardDir" select="$DashboardDir"/>
    </xsl:call-template>

  <xsl:call-template name="SummaryTable"/>
  <br/><br/> 
  <table>
      <tr>
        <th><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></th>
        <th colspan="2">Coverage status <img border="0"><xsl:attribute name="src"><xsl:value-of select="$IconDir"/>/DownBlack.gif</xsl:attribute></img></th>
      </tr>
      <tr>
        <th>Filename ( <a href="CoverageByName.html">sort by</a> )</th> 
        <th>Percentage ( <a href="CoverageByCount.html">sort by</a> )</th>
        <th>Lines not covered  (<a href="CoverageByUntested.html">sort by</a> )</th> 
      </tr>
      <xsl:for-each select="Site/Coverage/File">
        <xsl:sort select="@Covered" order="ascending"/>
        <xsl:sort select="CoverageMetric" data-type="number" order="ascending"/>
        <xsl:call-template name="File"/>
      </xsl:for-each>
    </table>
    <xsl:call-template name="DashboardFooter">
	<xsl:with-param name="IconDir">../../../../Icons</xsl:with-param>
    </xsl:call-template>
  </xsl:result-document>  
 </xsl:template>

  <xsl:template name="File">
    <tr>
      <xsl:if test="position() mod 2 = 0">
        <xsl:attribute name="bgcolor"><xsl:value-of select="$LightBlue"/></xsl:attribute>
      </xsl:if>
      
      <xsl:choose>
        <xsl:when test="@Covered='true'">
          <td align="left">
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="TranslateTestName">
                  <xsl:with-param name="Prefix">../Coverage/</xsl:with-param>
                  <xsl:with-param name="TestName" select="@FullPath"/>
                  <xsl:with-param name="Postfix">.html</xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
              <xsl:call-template name="SoftHyphenStringAtSlash">
                <xsl:with-param name="src">
	          <xsl:value-of select="string(@FullPath)"/>
                </xsl:with-param>
	      </xsl:call-template>
            </a>
          </td>
          <td align="center">
            <xsl:choose>
              <xsl:when test="CoverageMetric &lt; 0.5">
                <xsl:attribute name="bgcolor"><xsl:value-of select="$ErrorColor"/></xsl:attribute>
              </xsl:when> 
              <xsl:when test="CoverageMetric &gt;= 0.7">
                <xsl:attribute name="bgcolor"><xsl:value-of select="$NormalColor"/></xsl:attribute>
              </xsl:when>
              <xsl:otherwise>
                <xsl:attribute name="bgcolor"><xsl:value-of select="$WarningColor"/></xsl:attribute>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="PercentCoverage"/>%
          </td>
          <td align="center">
            <xsl:choose>
              <xsl:when test="CoverageMetric &lt; 0.5">
                <xsl:attribute name="bgcolor"><xsl:value-of select="$ErrorColor"/></xsl:attribute>
              </xsl:when> 
              <xsl:when test="CoverageMetric &gt;= 0.7">
                <xsl:attribute name="bgcolor"><xsl:value-of select="$NormalColor"/></xsl:attribute>
              </xsl:when>
              <xsl:otherwise>
                <xsl:attribute name="bgcolor"><xsl:value-of select="$WarningColor"/></xsl:attribute>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="LOCUnTested"/>
          </td>
        </xsl:when>
        <xsl:when test="@Covered='false'">
          <td align="left">
              <xsl:variable name="fullpath" select="@FullPath"/>
              <xsl:call-template name="SoftHyphenStringAtSlash">
                <xsl:with-param name="src" select="$fullpath"/>
	      </xsl:call-template>
          </td>
          <td align="center">UNTESTED</td>
          <td align="center">UNTESTED</td>
        </xsl:when>
      </xsl:choose>
    </tr>
  </xsl:template>

    <xsl:template name="SummaryTable">
    <h3>Coverage started on <xsl:value-of select="Site/Coverage/StartDateTime"/></h3>
 <table cellpadding="30">
 <tr>
 <td> 
 <table border="0" cellpadding="3" cellspacing="1" bgcolor="#0000aa" width="300">
      <tr><th colspan="2" class="table-heading">Coverage Summary</th></tr>
      <tr>
        <td bgcolor="#ffffff" align="left" width="60%"> Total Coverage</td> 
        <td align="center">
        <xsl:choose>
            <xsl:when test="Site/Coverage/PercentCoverage &lt; 50">
              <xsl:attribute name="bgcolor"><xsl:value-of select="$ErrorColor"/></xsl:attribute>
            </xsl:when> 
            <xsl:when test="Site/Coverage/PercentCoverage &gt;= 70.0">
              <xsl:attribute name="bgcolor"><xsl:value-of select="$NormalColor"/></xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="bgcolor"><xsl:value-of select="$WarningColor"/></xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:value-of select="Site/Coverage/PercentCoverage"/>%
        </td>
      </tr>    
      <tr>
        <td bgcolor="#ffffff" align="left"> Tested lines</td>
        <td bgcolor="#ffffff" align="right"><xsl:value-of select="Site/Coverage/LOCTested"/></td>
      </tr>
      <tr>
        <td bgcolor="#ffffff" align="left">Untested lines</td> 
        <td bgcolor="#ffffff" align="right"><xsl:value-of select="Site/Coverage/LOCUntested"/></td>
      </tr>
      <tr>
        <td bgcolor="#ffffff" align="left">Files Covered</td>
        <td bgcolor="#ffffff" align="center"><xsl:value-of select="count(Site/Coverage/File[@Covered='true'])"/>  of <xsl:value-of select="count(Site/Coverage/File)"/></td>
      </tr>
      <tr>
        <td bgcolor="#ffffff" align="left">Files Satisfactorily Covered</td>
        <td bgcolor="#ffffff" align="right">
        <xsl:value-of select="count(Site/Coverage/File[@Covered='true']/CoverageMetric[node() &gt;= 0.7])"/>
        </td>
      </tr>
      <tr>
        <td bgcolor="#ffffff" align="left">Files Unsatisfactorily Covered</td>
        <td bgcolor="#ffffff" align="right">         
        <xsl:value-of select="count(Site/Coverage/File[@Covered='true']/CoverageMetric[node() &lt; 0.7])"/>
        </td>
      </tr>
    </table>
   </td>
   <td valign="Top">
   <table border="0" cellpadding="3" cellspacing="1" bgcolor="#0000aa" width="350" >
   <tr class="table-heading">
      <th>Coverage Legend</th>
   </tr>
   <tr>
      <td align="center">
        <xsl:attribute name="bgcolor"><xsl:value-of select="$NormalColor"/></xsl:attribute>
        Satisfactory coverage
      </td>
   </tr> 
   <tr>
     <td align="center">
       <xsl:attribute name="bgcolor"><xsl:value-of select="$WarningColor"/></xsl:attribute>
        Unstatisfactory coverage
     </td>
  </tr> 
  <tr>
      <td align="center">
        <xsl:attribute name="bgcolor"><xsl:value-of select="$ErrorColor"/></xsl:attribute>
        Dangerously low coverage
      </td>
   </tr></table>
   </td></tr></table>
 </xsl:template>

<xsl:template name="Summary">
  <xsl:variable name="uri" select="concat('file:///', $TestDocDir, '/CoverageSummary.xml' )"/>
  <xsl:result-document href="{$uri}" >
    <Coverage>
      <SiteName><xsl:value-of select="Site/@Name"/></SiteName>
      <BuildName><xsl:value-of select="Site/@BuildName"/></BuildName>
      <BuildStamp><xsl:value-of select="Site/@BuildStamp"/></BuildStamp>
      <StartDateTime><xsl:value-of select="Site/Coverage/StartDateTime"/></StartDateTime>
      <PercentCoverage><xsl:value-of select="Site/Coverage/PercentCoverage"/></PercentCoverage>
      <LOCTested><xsl:value-of select="Site/Coverage/LOCTested"/></LOCTested>
      <LOCUntested><xsl:value-of select="Site/Coverage/LOCUntested"/></LOCUntested>
      <LOC><xsl:value-of select="Site/Coverage/LOC"/></LOC>
      <Passed><xsl:value-of select="count(Site/Coverage/File[@Covered='true']/CoverageMetric[node() &gt;= 0.7])"/></Passed>
      <Failed><xsl:value-of select="count(Site/Coverage/File[@Covered='true']/CoverageMetric[node() &lt; 0.7])"/></Failed>
      <EndDateTime><xsl:value-of select="Site/Coverage/EndDateTime"/></EndDateTime>
    </Coverage>
  </xsl:result-document>
 </xsl:template>


</xsl:stylesheet>
