#!/usr/bin/env python
#
# Script that will upload files to specified directory on the server, where
# triggering script will find it.
#
# Installation:
#    Place this script in your cgi-bin area. 
#    Change the variable "incoming_directory" to match your 
#        installation. 
#
# Author:
#    Andy Cedilnik andy.cedilnik@kitware.com
#
###

# Location where the files will be copied
incoming_directory = '/dart_incoming'

import cgi
import re
import sys
import os
import string

print "Content-type: text/html"
print

done = 0

form = cgi.FieldStorage()

# Debug
#try:
#  tmpfile = open("/tmp/http_upload_log_file.log", "w")
#  tmpfile.write(`form`)
#  tmpfile.close()
#except Exception: pass

FileData = ""
FileName = ""

# process form
if type(form.value) == type("foo"):
 if os.environ.has_key("QUERY_STRING"):
   dt = cgi.parse_qs(os.environ["QUERY_STRING"])
   if dt.has_key("FileName"):
     FileName = dt["FileName"][0]
   FileData = form.value
elif form.has_key("FileName"):
 FileName = form["FileName"].value
 if form.has_key("FileData"):
    FileData = "form"

# verify file specified
if not FileData or not FileName:
  print "Please send file. "
  print "FileName has to contain file name"
  print "FileData has to contain file content"
  print form
  sys.exit(0)

print "Received file: " + FileName

# check if valid file name
filename = re.sub("[/\\|:%%]", "_", FileName)
if re.match(".+___.+___[0-9]{8}-[0-9]{4}-(Experimental|Nightly|Continuous)___XML___([A-Za-z0-9-]+).xml", filename):
  print "Correct file name"
else:
  print "Can only upload files with format:"
  print "<site>___<BuildType>___<TAG>-<TestType>___XML___<File>.xml"
  sys.exit(0)

# get the file data
file_lines = ""
if FileData == "form":
  fileitem = form["FileData"]
  if fileitem.file:
    file_lines = fileitem.file.read()
  else:
    print "Not a file"
else:
  file_lines = FileData

# write to a file on disk
if file_lines:
  try:
    os.makedirs(incoming_directory)
  except: pass
  file = open(incoming_directory + "/" + filename, "w")
  if not file:
    print "Cannot create file: %s/%s" % ( incoming_directory, filename )
    sys.exit(0)
  file.write(file_lines)
  file.close()
  print "Thank you for the file"
  done = 1

if not done:
  print "Problem submiting data"
sys.exit(0)
