/* 
** Default values for constants.
 */

/*
 *  This file is part of davfs2.
 *
 *  davfs2 is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  davfs2 is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with davfs2; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef __DEFAULTS_H__
#define __DEFAULTS_H__


/* General */
/*=========*/

#define DAV_HOME "http://dav.sourceforge.net"

/* File system type to be used with 'mount -t' and fstab. */
#define DAV_FS_TYPE "davfs"

/* Mount options set by mount program in case of mounting by an
   ordinary user. */
#define DAV_USER_MOPTS (MS_MGC_VAL | MS_NOSUID | MS_NOEXEC | MS_NODEV)

/* This mount options will allways be set by davfs2. Different values from
   command line and even fstab will be silently ignored. */
#define DAV_MOPTS (MS_MGC_VAL | MS_NOSUID | MS_NODEV)

/* Ordinary users must be member of this group to be able to mount. */
#define DAV_GROUP "users"

/* XML namespace for the cache index file. */
#define DAV_XML_NS "http://dav.sf.net/"

/* Directories and Files */
/*=======================*/

/* The device directory. */
#define DAV_DEV_DIR "/dev"

/* The name used to build the device name (/dev/cfsX). */
#define DAV_DEV_NAME "cfs"

/* The file davfs reads mtab entries from. If not available it will
   use _PATH_MOUNTED. */
#define DAV_MOUNTS "/proc/mounts"

/* System wide configuration file. */
#define DAV_SYS_CONF SYSCONFDIR "/" PACKAGE_TARNAME ".conf"

/* System wide credentials file. */
#define DAV_SYS_SECRETS SYSCONFDIR "/" "secrets"

/* The directory where the cache files will be stored, when mounted by root. */
#define DAV_SYS_CACHE "/var/cache/" PACKAGE_TARNAME

/* The directory where the pid-files will be placed. */
#define DAV_SYS_RUN "/var/run/" PROGRAM_NAME

/* Directory holding user config files and cache directory. */
#define DAV_USER_DIR "~/." PACKAGE_TARNAME

/* User configuration file; relative to DAV_USER_DIR. */
#define DAV_USER_CONF PACKAGE_TARNAME ".conf"

/* User file holding credentials; relative to DAV_USER_DIR. */
#define DAV_USER_SECRETS "secrets"

/* The directory where the cache files will be stored, when mounted by
   a non root users; relative to DAV_USER_DIR. */
#define DAV_USER_CACHE "cache"

/* The name of index files. */
#define DAV_INDEX "index"

/* Name of the directory within the davfs2 filesystem that holds local
   backup files. */
#define DAV_BACKUP_DIR "dav-local-backup"

/* Buffer size for reading the XML index files of persistent cache. */
#define DAV_XML_BUF_SIZE 16 * 1024


/* Cache Optimization */
/*====================*/

/* Cache size in MiByte.
   (1 MiByte = 1,048,576 Byte; Mi = Mebi = Mega Binary according to IEC) */
#define DAV_CACHE_SIZE 50

/* Size of the hash table to store nodes. Should be a power of 2. */
#define DAV_TABLE_SIZE 1024

/* The time in seconds to wait before the idle function is called, when
   there are no upcalls from kernel. The idle function will mainly put
   back files to the server. */
#define DAV_IDLE_TIME 10

/* How long in seconds a cached directory is valid. After this time
   a new PROPFIND request for this directory must be performed. */
#define DAV_EXPIRE 300

/* Default retry time after a PROPFIND request failed. When the request fails
   again, the retry time will subsequently be increased up to DAV_MAX_RETRY. */
#define DAV_RETRY 30

/* Maximum retry time after a PROPFIND request failed.*/
#define DAV_MAX_RETRY 300


/* HTTP */
/*======*/

/* The default proxy port. */
#define DAV_DEFAULT_PROXY_PORT 8080

/* Whether to use a proxy if one is specified. */
#define DAV_USE_PROXY 1

/* Whether to ask user for credentials if not given. */
#define DAV_ASKAUTH 1

/* Whether to use locks. */
#define DAV_LOCKS 1

/* Timeout in seconds used when reading from a socket. */
#define DAV_READ_TIMEOUT 30


/* Kernel Interface */
/*==================*/

/* This constants are used by davfs2 to fill fields of struct CodaFid that
   are not used by davfs2, but are expected by coda. */   
#define DAV_VOL   0x01234567
#define DAV_VNODE 0xffffffff

/* The block size returned in struct coda_vattr for files and directories. */
#define DAV_BLKSIZE 0x400

/* There seems to be a minimum size for directory entries. */
#define DAV_MIN_DENTRY 12

/* The file system type used by davfs2 when calling the mount() function. */
#define DAV_KERNEL_FS_TYPE "coda"

/* The Coda mount version must be given by davfs2 when calling mount(). */
#define CODA_MOUNT_VERSION 1


#endif
