/* 
** Mount the davfs file system.
 */

/*
 *  This file is part of davfs2.
 *
 *  davfs2 is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  davfs2 is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with davfs2; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef __MOUNT_DAVFS_H__
#define __MOUNT_DAVFS_H__


/* Data Types */
/*============*/

/* This data structure holds everything davfs gathers while reading
 * and checking command line and configuration files. Some data will
 * be copied into global variables to be available in daemon mode.
 * The rest will be freed when forking into daemon mode. */
typedef struct {
    gid_t dav_group;          /* System config file */
    char *conf;               /* Command line */
    /* Mount options */
    char *mpoint;             /* Command line */
    int user;                 /* Command line */
    unsigned long int mopts;  /* Command line */
    int minor;
    int device;
    /* File mode */
    uid_t uid;                /* Command line */
    gid_t gid;                /* Command line */
    mode_t dir_umask;
    mode_t file_umask;
    mode_t dir_mode;          /* Command line */
    mode_t file_mode;         /* Command line */
    /* WebDAV-resource */
    char *url;                /* Command line */
    char *secrets;            /* User config file */
    char *username;           /* User secrets file, system secrets file */
    char *password;           /* User secrets file, system secrets file */
    char *p_host;             /* User config file, sys conf f., environment */
    int p_port;               /* User config file, sys conf f., environment */
    char *p_user;             /* User secrets file, system secrets file */
    char *p_passwd;           /* User secrets file, system secrets file */
    int useproxy;             /* Command line */
    int askauth;              /* Command line */
    int locks;                /* Command line */
    time_t read_timeout;      /* User config file, system config file */
    /* Cache */
    char *sys_cache;          /* System config file */
    char *cache_dir;          /* User config file */
    size_t cache_size;        /* User config file, system config file */
    size_t table_size;        /* User config file, system config file */
    time_t idle_time;         /* User config file, system config file */
    time_t expire;            /* User config file, system config file */
    time_t retry;             /* User config file, system config file */
    time_t max_retry;         /* User config file, system config file */
} dav_args;


/* Function prototypes */
/*=====================*/

/* Checks wether the file system is mounted.
 * It uses information from the private global variables mounts (mtab-file),
 * url (must be device in the mtab entry) and mpoint (mount point).
 * return value : 0 - no matching entry in the mtab-file (not mounted)
 *                1 - matching entry in the mtab-file (mounted) */
int dav_is_mounted(void);


#endif
