/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4oUnit.Tests
{
	public class ReflectionTestSuiteBuilderTestCase : Db4oUnit.ITestCase
	{
		private sealed class ExcludingReflectionTestSuiteBuilder : Db4oUnit.ReflectionTestSuiteBuilder
		{
			public ExcludingReflectionTestSuiteBuilder(System.Type[] classes) : base(classes)
			{
			}

			protected override bool IsApplicable(System.Type clazz)
			{
				return clazz != typeof(Db4oUnit.Tests.ReflectionTestSuiteBuilderTestCase.NotAccepted);
			}
		}

		public class NonTestFixture
		{
		}

		public virtual void TestUnmarkedTestFixture()
		{
			Db4oUnit.ReflectionTestSuiteBuilder builder = new Db4oUnit.ReflectionTestSuiteBuilder
				(typeof(Db4oUnit.Tests.ReflectionTestSuiteBuilderTestCase.NonTestFixture));
			Db4oUnit.Assert.Expect(typeof(System.ArgumentException), new _AnonymousInnerClass28
				(this, builder));
		}

		private sealed class _AnonymousInnerClass28 : Db4oUnit.ICodeBlock
		{
			public _AnonymousInnerClass28(ReflectionTestSuiteBuilderTestCase _enclosing, Db4oUnit.ReflectionTestSuiteBuilder
				 builder)
			{
				this._enclosing = _enclosing;
				this.builder = builder;
			}

			public void Run()
			{
				builder.Build();
			}

			private readonly ReflectionTestSuiteBuilderTestCase _enclosing;

			private readonly Db4oUnit.ReflectionTestSuiteBuilder builder;
		}

		public class Accepted : Db4oUnit.ITestCase
		{
			public virtual void Test()
			{
			}
		}

		public class NotAccepted : Db4oUnit.ITestCase
		{
			public virtual void Test()
			{
			}
		}

		public virtual void TestNotAcceptedFixture()
		{
			Db4oUnit.ReflectionTestSuiteBuilder builder = new Db4oUnit.Tests.ReflectionTestSuiteBuilderTestCase.ExcludingReflectionTestSuiteBuilder
				(new System.Type[] { typeof(Db4oUnit.Tests.ReflectionTestSuiteBuilderTestCase.Accepted)
				, typeof(Db4oUnit.Tests.ReflectionTestSuiteBuilderTestCase.NotAccepted) });
			Db4oUnit.Assert.AreEqual(1, builder.Build().GetTests().Length);
		}
	}
}
