/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Assorted
{
	public class ReferenceSystemTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		private static readonly int[] IDS = new int[] { 100, 134, 689, 666, 775 };

		private static readonly object[] REFERENCES = CreateReferences();

		public static void Main(string[] args)
		{
			new Db4objects.Db4o.Tests.Common.Assorted.ReferenceSystemTestCase().RunSolo();
		}

		public virtual void TestTransactionalReferenceSystem()
		{
			Db4objects.Db4o.Internal.TransactionalReferenceSystem transactionalReferenceSystem
				 = new Db4objects.Db4o.Internal.TransactionalReferenceSystem();
			AssertAllRerefencesAvailableOnNew(transactionalReferenceSystem);
			transactionalReferenceSystem.Rollback();
			AssertEmpty(transactionalReferenceSystem);
			AssertAllRerefencesAvailableOnCommit(transactionalReferenceSystem);
		}

		public virtual void TestHashCodeReferenceSystem()
		{
			Db4objects.Db4o.Internal.HashcodeReferenceSystem hashcodeReferenceSystem = new Db4objects.Db4o.Internal.HashcodeReferenceSystem
				();
			AssertAllRerefencesAvailableOnNew(hashcodeReferenceSystem);
		}

		private void AssertAllRerefencesAvailableOnCommit(Db4objects.Db4o.Internal.IReferenceSystem
			 referenceSystem)
		{
			FillReferenceSystem(referenceSystem);
			referenceSystem.Commit();
			AssertAllReferencesAvailable(referenceSystem);
		}

		private void AssertAllRerefencesAvailableOnNew(Db4objects.Db4o.Internal.IReferenceSystem
			 referenceSystem)
		{
			FillReferenceSystem(referenceSystem);
			AssertAllReferencesAvailable(referenceSystem);
		}

		private void AssertEmpty(Db4objects.Db4o.Internal.IReferenceSystem referenceSystem
			)
		{
			AssertContains(referenceSystem, new object[] {  });
		}

		private void AssertAllReferencesAvailable(Db4objects.Db4o.Internal.IReferenceSystem
			 referenceSystem)
		{
			AssertContains(referenceSystem, REFERENCES);
		}

		private void AssertContains(Db4objects.Db4o.Internal.IReferenceSystem referenceSystem
			, object[] objects)
		{
			Db4objects.Db4o.Tests.Common.Btree.ExpectingVisitor expectingVisitor = new Db4objects.Db4o.Tests.Common.Btree.ExpectingVisitor
				(objects);
			referenceSystem.TraverseReferences(expectingVisitor);
			expectingVisitor.AssertExpectations();
		}

		private void FillReferenceSystem(Db4objects.Db4o.Internal.IReferenceSystem referenceSystem
			)
		{
			for (int i = 0; i < REFERENCES.Length; i++)
			{
				referenceSystem.AddNewReference((Db4objects.Db4o.Internal.ObjectReference)REFERENCES
					[i]);
			}
		}

		private static object[] CreateReferences()
		{
			object[] references = new object[IDS.Length];
			for (int i = 0; i < IDS.Length; i++)
			{
				Db4objects.Db4o.Internal.ObjectReference @ref = new Db4objects.Db4o.Internal.ObjectReference
					(IDS[i]);
				@ref.SetObject(IDS[i].ToString());
				references[i] = @ref;
			}
			return references;
		}
	}
}
