/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Fieldindex
{
	/// <summary>Jira ticket: COR-373</summary>
	/// <exclude></exclude>
	public class StringIndexCorruptionTestCase : Db4objects.Db4o.Tests.Common.Fieldindex.StringIndexTestCaseBase
	{
		public static void Main(string[] arguments)
		{
			new Db4objects.Db4o.Tests.Common.Fieldindex.StringIndexCorruptionTestCase().RunSolo
				();
		}

		protected override void Configure(Db4objects.Db4o.Config.IConfiguration config)
		{
			base.Configure(config);
			config.BTreeNodeSize(4);
			config.FlushFileBuffers(false);
		}

		public virtual void TestStressSet()
		{
			Db4objects.Db4o.Ext.IExtObjectContainer container = Db();
			int itemCount = 300;
			for (int i = 0; i < itemCount; ++i)
			{
				Db4objects.Db4o.Tests.Common.Fieldindex.StringIndexTestCaseBase.Item item = new Db4objects.Db4o.Tests.Common.Fieldindex.StringIndexTestCaseBase.Item
					(ItemName(i));
				container.Set(item);
				container.Set(item);
				container.Commit();
				container.Set(item);
				container.Set(item);
				container.Commit();
			}
			for (int i = 0; i < itemCount; ++i)
			{
				string itemName = ItemName(i);
				Db4objects.Db4o.Tests.Common.Fieldindex.StringIndexTestCaseBase.Item found = Query
					(itemName);
				Db4oUnit.Assert.IsNotNull(found, "'" + itemName + "' not found");
				Db4oUnit.Assert.AreEqual(itemName, found.name);
			}
		}

		private string ItemName(int i)
		{
			return "item " + i;
		}
	}
}
