/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Foundation
{
	/// <exclude></exclude>
	public class Iterable4AdaptorTestCase : Db4oUnit.ITestCase
	{
		public virtual void TestEmptyIterator()
		{
			Db4objects.Db4o.Foundation.Iterable4Adaptor adaptor = NewAdaptor(new int[] {  });
			Db4oUnit.Assert.IsFalse(adaptor.HasNext());
			Db4oUnit.Assert.IsFalse(adaptor.HasNext());
			Db4oUnit.Assert.Expect(typeof(System.InvalidOperationException), new _AnonymousInnerClass20
				(this, adaptor));
		}

		private sealed class _AnonymousInnerClass20 : Db4oUnit.ICodeBlock
		{
			public _AnonymousInnerClass20(Iterable4AdaptorTestCase _enclosing, Db4objects.Db4o.Foundation.Iterable4Adaptor
				 adaptor)
			{
				this._enclosing = _enclosing;
				this.adaptor = adaptor;
			}

			public void Run()
			{
				adaptor.Next();
			}

			private readonly Iterable4AdaptorTestCase _enclosing;

			private readonly Db4objects.Db4o.Foundation.Iterable4Adaptor adaptor;
		}

		public virtual void TestHasNext()
		{
			int[] expected = new int[] { 1, 2, 3 };
			Db4objects.Db4o.Foundation.Iterable4Adaptor adaptor = NewAdaptor(expected);
			for (int i = 0; i < expected.Length; i++)
			{
				AssertHasNext(adaptor);
				Db4oUnit.Assert.AreEqual(expected[i], adaptor.Next());
			}
			Db4oUnit.Assert.IsFalse(adaptor.HasNext());
		}

		public virtual void TestNext()
		{
			int[] expected = new int[] { 1, 2, 3 };
			Db4objects.Db4o.Foundation.Iterable4Adaptor adaptor = NewAdaptor(expected);
			for (int i = 0; i < expected.Length; i++)
			{
				Db4oUnit.Assert.AreEqual(expected[i], adaptor.Next());
			}
			Db4oUnit.Assert.IsFalse(adaptor.HasNext());
		}

		private Db4objects.Db4o.Foundation.Iterable4Adaptor NewAdaptor(int[] expected)
		{
			return new Db4objects.Db4o.Foundation.Iterable4Adaptor(NewIterable(expected));
		}

		private void AssertHasNext(Db4objects.Db4o.Foundation.Iterable4Adaptor adaptor)
		{
			for (int i = 0; i < 10; ++i)
			{
				Db4oUnit.Assert.IsTrue(adaptor.HasNext());
			}
		}

		private System.Collections.IEnumerable NewIterable(int[] values)
		{
			Db4objects.Db4o.Foundation.Collection4 collection = new Db4objects.Db4o.Foundation.Collection4
				();
			collection.AddAll(Db4objects.Db4o.Tests.Common.Foundation.IntArrays4.ToObjectArray
				(values));
			return collection;
		}
	}
}
