/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Foundation
{
	/// <exclude></exclude>
	public class IteratorsTestCase : Db4oUnit.ITestCase
	{
		public virtual void TestFilter()
		{
			AssertFilter(new string[] { "bar", "baz" }, new string[] { "foo", "bar", "baz", "zong"
				 }, new _AnonymousInnerClass18(this));
			AssertFilter(new string[] { "foo", "bar" }, new string[] { "foo", "bar" }, new _AnonymousInnerClass26
				(this));
			AssertFilter(new string[0], new string[] { "foo", "bar" }, new _AnonymousInnerClass35
				(this));
		}

		private sealed class _AnonymousInnerClass18 : Db4objects.Db4o.Foundation.IPredicate4
		{
			public _AnonymousInnerClass18(IteratorsTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public bool Match(object candidate)
			{
				return ((string)candidate).StartsWith("b");
			}

			private readonly IteratorsTestCase _enclosing;
		}

		private sealed class _AnonymousInnerClass26 : Db4objects.Db4o.Foundation.IPredicate4
		{
			public _AnonymousInnerClass26(IteratorsTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public bool Match(object candidate)
			{
				return true;
			}

			private readonly IteratorsTestCase _enclosing;
		}

		private sealed class _AnonymousInnerClass35 : Db4objects.Db4o.Foundation.IPredicate4
		{
			public _AnonymousInnerClass35(IteratorsTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public bool Match(object candidate)
			{
				return false;
			}

			private readonly IteratorsTestCase _enclosing;
		}

		private void AssertFilter(string[] expected, string[] actual, Db4objects.Db4o.Foundation.IPredicate4
			 filter)
		{
			Db4objects.Db4o.Tests.Common.Foundation.IteratorAssert.AreEqual(expected, Db4objects.Db4o.Foundation.Iterators
				.Filter(actual, filter));
		}

		public virtual void TestMap()
		{
			int[] array = new int[] { 1, 2, 3 };
			Db4objects.Db4o.Foundation.Collection4 args = new Db4objects.Db4o.Foundation.Collection4
				();
			System.Collections.IEnumerator iterator = Db4objects.Db4o.Foundation.Iterators.Map
				(Db4objects.Db4o.Tests.Common.Foundation.IntArrays4.NewIterator(array), new _AnonymousInnerClass51
				(this, args));
			Db4oUnit.Assert.IsNotNull(iterator);
			Db4oUnit.Assert.AreEqual(0, args.Size());
			for (int i = 0; i < array.Length; ++i)
			{
				Db4oUnit.Assert.IsTrue(iterator.MoveNext());
				Db4oUnit.Assert.AreEqual(i + 1, args.Size());
				Db4oUnit.Assert.AreEqual(array[i] * 2, iterator.Current);
			}
		}

		private sealed class _AnonymousInnerClass51 : Db4objects.Db4o.Foundation.IFunction4
		{
			public _AnonymousInnerClass51(IteratorsTestCase _enclosing, Db4objects.Db4o.Foundation.Collection4
				 args)
			{
				this._enclosing = _enclosing;
				this.args = args;
			}

			public object Apply(object arg)
			{
				args.Add(arg);
				return ((int)arg) * 2;
			}

			private readonly IteratorsTestCase _enclosing;

			private readonly Db4objects.Db4o.Foundation.Collection4 args;
		}
	}
}
