/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Events
{
	/// <summary>
	/// Provides an interface for getting an
	/// <see cref="Db4objects.Db4o.Events.IEventRegistry">Db4objects.Db4o.Events.IEventRegistry
	/// 	</see>
	/// from an
	/// <see cref="Db4objects.Db4o.IObjectContainer">Db4objects.Db4o.IObjectContainer</see>
	/// .
	/// </summary>
	public class EventRegistryFactory
	{
		/// <summary>
		/// Returns an
		/// <see cref="Db4objects.Db4o.Events.IEventRegistry">Db4objects.Db4o.Events.IEventRegistry
		/// 	</see>
		/// for registering events with the specified container.
		/// </summary>
		public static Db4objects.Db4o.Events.IEventRegistry ForObjectContainer(Db4objects.Db4o.IObjectContainer
			 container)
		{
			if (null == container)
			{
				throw new System.ArgumentNullException("container");
			}
			Db4objects.Db4o.Internal.ObjectContainerBase stream = ((Db4objects.Db4o.Internal.ObjectContainerBase
				)container);
			Db4objects.Db4o.Internal.Callbacks.ICallbacks callbacks = stream.Callbacks();
			if (callbacks is Db4objects.Db4o.Events.IEventRegistry)
			{
				return (Db4objects.Db4o.Events.IEventRegistry)callbacks;
			}
			if (callbacks is Db4objects.Db4o.Internal.Callbacks.NullCallbacks)
			{
				Db4objects.Db4o.Internal.Events.EventRegistryImpl impl = new Db4objects.Db4o.Internal.Events.EventRegistryImpl
					();
				stream.Callbacks(impl);
				return impl;
			}
			throw new System.ArgumentException("container callbacks already in use");
		}
	}
}
