/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.CS.Messages
{
	/// <exclude></exclude>
	public class MObjectSetFetch : Db4objects.Db4o.Internal.CS.Messages.MObjectSet
	{
		public override bool ProcessAtServer(Db4objects.Db4o.Internal.CS.ServerMessageDispatcher
			 serverThread)
		{
			int queryResultID = ReadInt();
			int fetchSize = ReadInt();
			Db4objects.Db4o.Foundation.IIntIterator4 idIterator = Stub(serverThread, queryResultID
				).IdIterator();
			Db4objects.Db4o.Internal.CS.Messages.MsgD message = ID_LIST.GetWriterForLength(Transaction
				(), BufferLength(fetchSize));
			Db4objects.Db4o.Internal.StatefulBuffer writer = message.PayLoad();
			writer.WriteIDs(idIterator, fetchSize);
			serverThread.Write(message);
			return true;
		}

		private int BufferLength(int fetchSize)
		{
			return Db4objects.Db4o.Internal.Const4.INT_LENGTH * (fetchSize + 1);
		}
	}
}
