/* Copyright (C) 2004 - 2006  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.Mapping
{
	/// <exclude></exclude>
	public class MappedIDPairHandler : Db4objects.Db4o.Internal.IX.IIndexable4
	{
		private readonly Db4objects.Db4o.Internal.Handlers.IntHandler _origHandler;

		private readonly Db4objects.Db4o.Internal.Handlers.IntHandler _mappedHandler;

		public MappedIDPairHandler(Db4objects.Db4o.Internal.ObjectContainerBase stream)
		{
			_origHandler = new Db4objects.Db4o.Internal.Handlers.IntHandler(stream);
			_mappedHandler = new Db4objects.Db4o.Internal.Handlers.IntHandler(stream);
		}

		public virtual object ComparableObject(Db4objects.Db4o.Internal.Transaction trans
			, object indexEntry)
		{
			throw new System.NotImplementedException();
		}

		public virtual void DefragIndexEntry(Db4objects.Db4o.Internal.ReaderPair readers)
		{
			throw new System.NotImplementedException();
		}

		public virtual int LinkLength()
		{
			return _origHandler.LinkLength() + _mappedHandler.LinkLength();
		}

		public virtual object ReadIndexEntry(Db4objects.Db4o.Internal.Buffer reader)
		{
			int origID = ReadID(reader);
			int mappedID = ReadID(reader);
			return new Db4objects.Db4o.Internal.Mapping.MappedIDPair(origID, mappedID);
		}

		public virtual void WriteIndexEntry(Db4objects.Db4o.Internal.Buffer reader, object
			 obj)
		{
			Db4objects.Db4o.Internal.Mapping.MappedIDPair mappedIDs = (Db4objects.Db4o.Internal.Mapping.MappedIDPair
				)obj;
			_origHandler.WriteIndexEntry(reader, mappedIDs.Orig());
			_mappedHandler.WriteIndexEntry(reader, mappedIDs.Mapped());
		}

		public virtual int CompareTo(object obj)
		{
			return _origHandler.CompareTo(((Db4objects.Db4o.Internal.Mapping.MappedIDPair)obj
				).Orig());
		}

		public virtual object Current()
		{
			return new Db4objects.Db4o.Internal.Mapping.MappedIDPair(_origHandler.CurrentInt(
				), _mappedHandler.CurrentInt());
		}

		public virtual bool IsEqual(object obj)
		{
			throw new System.NotImplementedException();
		}

		public virtual bool IsGreater(object obj)
		{
			throw new System.NotImplementedException();
		}

		public virtual bool IsSmaller(object obj)
		{
			throw new System.NotImplementedException();
		}

		public virtual Db4objects.Db4o.Internal.IComparable4 PrepareComparison(object obj
			)
		{
			Db4objects.Db4o.Internal.Mapping.MappedIDPair mappedIDs = (Db4objects.Db4o.Internal.Mapping.MappedIDPair
				)obj;
			_origHandler.PrepareComparison(mappedIDs.Orig());
			_mappedHandler.PrepareComparison(mappedIDs.Mapped());
			return this;
		}

		private int ReadID(Db4objects.Db4o.Internal.Buffer a_reader)
		{
			return ((int)_origHandler.ReadIndexEntry(a_reader));
		}
	}
}
